/*
 * Decompiled with CFR 0.152.
 */
package org.logl;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.logl.LogMessage;
import org.logl.NullLogWriter;

public interface LogWriter {
    public static LogWriter nullWriter() {
        return NullLogWriter.instance();
    }

    public void log(LogMessage var1);

    default public void log(CharSequence message) {
        Objects.requireNonNull(message);
        this.log((Locale l, Appendable a) -> a.append(message));
    }

    default public void log(Supplier<? extends CharSequence> messageSupplier) {
        Objects.requireNonNull(messageSupplier);
        this.log((Locale l, Appendable a) -> a.append((CharSequence)messageSupplier.get()));
    }

    public void log(LogMessage var1, Throwable var2);

    default public void log(CharSequence message, Throwable cause) {
        Objects.requireNonNull(message);
        this.log((Locale l, Appendable a) -> a.append(message), cause);
    }

    default public void log(Supplier<? extends CharSequence> messageSupplier, Throwable cause) {
        Objects.requireNonNull(messageSupplier);
        this.log((Locale l, Appendable a) -> a.append((CharSequence)messageSupplier.get()), cause);
    }

    default public void log(String pattern, Object ... args) {
        if (args.length == 1 && args[0] instanceof Throwable) {
            this.log((CharSequence)pattern, (Throwable)args[0]);
        } else {
            this.log(LogMessage.patternFormat(pattern, args));
        }
    }

    default public void logf(String format, Object ... args) {
        this.log(LogMessage.stringFormat(format, args));
    }

    public void batch(Consumer<LogWriter> var1);
}

