/*
 * Decompiled with CFR 0.152.
 */
package org.logl;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import org.logl.MessageFormatter;

@FunctionalInterface
public interface LogMessage {
    public static LogMessage stringFormat(String format, Object ... args) {
        Objects.requireNonNull(format);
        return (l, a) -> {
            if (a instanceof PrintWriter) {
                ((PrintWriter)a).format(l, format, args);
                return;
            }
            new Formatter(a).format(l, format, args);
        };
    }

    public static LogMessage messageFormat(String pattern, Object ... args) {
        Objects.requireNonNull(pattern);
        return (l, a) -> {
            MessageFormat messageFormat = new MessageFormat(pattern, l);
            if (a instanceof StringBuffer) {
                messageFormat.format(args, (StringBuffer)a, (FieldPosition)null);
            } else {
                a.append(messageFormat.format(args));
            }
        };
    }

    public static LogMessage patternFormat(String pattern, Object ... args) {
        Objects.requireNonNull(pattern);
        return (l, a) -> MessageFormatter.formatTo(pattern, args, a);
    }

    public void appendTo(Locale var1, Appendable var2) throws IOException;
}

