/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.loggly;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;

public abstract class AbstractLogglyAppender<E>
extends UnsynchronizedAppenderBase<E> {
    public static final String DEFAULT_ENDPOINT_PREFIX = "https://logs-01.loggly.com/";
    public static final String DEFAULT_LAYOUT_PATTERN = "%d{\"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'\",UTC} %-5level [%thread] %logger: %m%n";
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    protected String endpointUrl;
    protected String inputKey;
    protected Layout<E> layout;
    protected boolean layoutCreatedImplicitly = false;
    private String pattern;
    private int proxyPort;
    private String proxyHost;
    protected Proxy proxy;
    private int httpReadTimeoutInMillis = 1000;

    public void start() {
        this.ensureLayout();
        if (!this.layout.isStarted()) {
            this.layout.start();
        }
        if (this.endpointUrl == null) {
            if (this.inputKey == null) {
                this.addError("inputKey (or alternatively, endpointUrl) must be configured");
            } else {
                this.endpointUrl = this.buildEndpointUrl(this.inputKey);
            }
        }
        this.proxy = this.proxyHost == null || this.proxyHost.isEmpty() ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.layoutCreatedImplicitly) {
            try {
                this.layout.stop();
            }
            finally {
                this.layout = null;
                this.layoutCreatedImplicitly = false;
            }
        }
    }

    protected byte[] toBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readResponseBody(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = this.toBytes(inputStream);
            String string = new String(byArray, UTF_8);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    protected final void ensureLayout() {
        Context context;
        if (this.layout == null) {
            this.layout = this.createLayout();
            this.layoutCreatedImplicitly = true;
        }
        if (this.layout != null && (context = this.layout.getContext()) == null) {
            this.layout.setContext(this.getContext());
        }
    }

    protected Layout<E> createLayout() {
        PatternLayout patternLayout = new PatternLayout();
        String string = this.getPattern();
        if (string == null) {
            string = DEFAULT_LAYOUT_PATTERN;
        }
        patternLayout.setPattern(string);
        return patternLayout;
    }

    protected String buildEndpointUrl(String string) {
        return DEFAULT_ENDPOINT_PREFIX + this.getEndpointPrefix() + string;
    }

    protected abstract String getEndpointPrefix();

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String string) {
        this.endpointUrl = string;
    }

    public String getInputKey() {
        return this.inputKey;
    }

    public void setInputKey(String string) {
        String string2 = string;
        if (string2 != null) {
            string2 = string2.trim();
        }
        if ("".equals(string2)) {
            string2 = null;
        }
        this.inputKey = string2;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public void setProxyPort(String string) {
        if (string == null || string.trim().isEmpty()) {
            string = "0";
        }
        this.proxyPort = Integer.parseInt(string);
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String string) {
        if (string == null || string.trim().isEmpty()) {
            string = null;
        }
        this.proxyHost = string;
    }

    public int getHttpReadTimeoutInMillis() {
        return this.httpReadTimeoutInMillis;
    }

    public void setHttpReadTimeoutInMillis(int n) {
        this.httpReadTimeoutInMillis = n;
    }
}

