/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor.job;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.lockss.db.DbManagerSql;
import org.lockss.util.Logger;
import org.lockss.util.StringUtil;

public class JobDbManagerSql
extends DbManagerSql {
    private static final Logger log = Logger.getLogger(JobDbManagerSql.class);
    private static final String CREATE_JOB_TYPE_TABLE_QUERY = "create table job_type (job_type_seq --BigintSerialPk--,type_name varchar(32) not null)";
    private static final String CREATE_JOB_STATUS_TABLE_QUERY = "create table job_status (job_status_seq --BigintSerialPk--,status_name varchar(32) not null)";
    private static final String CREATE_JOB_TABLE_QUERY = "create table job (job_seq --BigintSerialPk--,job_type_seq bigint not null references job_type (job_type_seq) on delete cascade,description varchar(128),plugin_id varchar(256) not null,au_key varchar(512) not null,creation_time bigint not null,start_time bigint,end_time bigint,job_status_seq bigint not null references job_status (job_status_seq) on delete cascade,status_message varchar(512),priority bigint not null,owner varchar(32))";
    private static final String CREATE_JOB_METADATA_TABLE_QUERY = "create table job_metadata (truncation_time bigint)";
    private static final Map<String, String> VERSION_1_TABLE_CREATE_QUERIES = new LinkedHashMap<String, String>(){
        {
            this.put("job_type", JobDbManagerSql.CREATE_JOB_TYPE_TABLE_QUERY);
            this.put("job_status", JobDbManagerSql.CREATE_JOB_STATUS_TABLE_QUERY);
            this.put("job", JobDbManagerSql.CREATE_JOB_TABLE_QUERY);
        }
    };
    private static final String[] VERSION_1_INDEX_CREATE_QUERIES = new String[]{"create unique index idx1_job on job(priority)", "create index idx2_job on job(plugin_id,au_key)", "create index idx3_job on job(owner)", "create index idx4_job on job(job_type_seq)"};
    private static final String[] VERSION_1_INDEX_CREATE_MYSQL_QUERIES = new String[]{"create unique index idx1_job on job(priority)", "create index idx2_job on job(plugin_id(255),au_key(255))", "create index idx3_job on job(owner)", "create index idx4_job on job(job_type_seq)"};
    private static final String INSERT_JOB_TYPE_QUERY = "insert into job_type(job_type_seq,type_name) values (default,?)";
    private static final String INSERT_JOB_STATUS_QUERY = "insert into job_status(job_status_seq,status_name) values (default,?)";
    private static final Map<String, String> VERSION_3_TABLE_CREATE_QUERIES = new LinkedHashMap<String, String>(){
        {
            this.put("job_metadata", JobDbManagerSql.CREATE_JOB_METADATA_TABLE_QUERY);
        }
    };
    private static final String INSERT_JOB_METADATA_QUERY = "insert into job_metadata(truncation_time) values (0)";

    JobDbManagerSql(DataSource dataSource, String dataSourceClassName, String dataSourceUser, int maxRetryCount, long retryDelay, int fetchSize) {
        super(dataSource, dataSourceClassName, dataSourceUser, maxRetryCount, retryDelay, fetchSize);
    }

    void setUpDatabaseVersion1(Connection conn) throws SQLException {
        String DEBUG_HEADER = "setUpDatabaseVersion1(): ";
        if (log.isDebug2()) {
            log.debug2("setUpDatabaseVersion1(): Starting...");
        }
        if (conn == null) {
            throw new IllegalArgumentException("Null connection");
        }
        this.createTablesIfMissing(conn, VERSION_1_TABLE_CREATE_QUERIES);
        this.addJobType(conn, "put_au");
        this.addJobType(conn, "delete_au");
        this.addJobStatus(conn, "created");
        this.addJobStatus(conn, "running");
        this.addJobStatus(conn, "terminating");
        this.addJobStatus(conn, "terminated");
        this.addJobStatus(conn, "done");
        this.addJobStatus(conn, "deleted");
        if (this.isTypeMysql()) {
            this.executeDdlQueries(conn, VERSION_1_INDEX_CREATE_MYSQL_QUERIES);
        } else {
            this.executeDdlQueries(conn, VERSION_1_INDEX_CREATE_QUERIES);
        }
        if (log.isDebug2()) {
            log.debug2("setUpDatabaseVersion1(): Done.");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addJobType(Connection conn, String typeName) throws SQLException {
        String DEBUG_HEADER = "addJobType(): ";
        if (log.isDebug2()) {
            log.debug2("addJobType(): typeName = '" + typeName + "'.");
        }
        if (StringUtil.isNullString((String)typeName)) {
            return;
        }
        if (conn == null) {
            throw new IllegalArgumentException("Null connection");
        }
        PreparedStatement insertJobType = null;
        try {
            insertJobType = this.prepareStatement(conn, INSERT_JOB_TYPE_QUERY);
            insertJobType.setString(1, typeName);
            int count = this.executeUpdate(insertJobType);
            if (log.isDebug3()) {
                log.debug3("addJobType(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            try {
                log.error("Cannot add a job type", (Throwable)sqle);
                log.error("typeName = '" + typeName + "'.");
                log.error("SQL = 'insert into job_type(job_type_seq,type_name) values (default,?)'.");
                throw sqle;
                catch (RuntimeException re) {
                    log.error("Cannot add a job type", (Throwable)re);
                    log.error("typeName = '" + typeName + "'.");
                    log.error("SQL = 'insert into job_type(job_type_seq,type_name) values (default,?)'.");
                    throw re;
                }
            }
            catch (Throwable throwable) {
                JobDbManagerSql.safeCloseStatement(insertJobType);
                throw throwable;
            }
        }
        JobDbManagerSql.safeCloseStatement((Statement)insertJobType);
        if (log.isDebug2()) {
            log.debug2("addJobType(): Done.");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addJobStatus(Connection conn, String statusName) throws SQLException {
        String DEBUG_HEADER = "addJobStatus(): ";
        if (log.isDebug2()) {
            log.debug2("addJobStatus(): statusName = '" + statusName + "'.");
        }
        if (StringUtil.isNullString((String)statusName)) {
            return;
        }
        if (conn == null) {
            throw new IllegalArgumentException("Null connection");
        }
        PreparedStatement insertJobStatus = null;
        try {
            insertJobStatus = this.prepareStatement(conn, INSERT_JOB_STATUS_QUERY);
            insertJobStatus.setString(1, statusName);
            int count = this.executeUpdate(insertJobStatus);
            if (log.isDebug3()) {
                log.debug3("addJobStatus(): count = " + count);
            }
        }
        catch (SQLException sqle) {
            try {
                log.error("Cannot add a job status", (Throwable)sqle);
                log.error("statusName = '" + statusName + "'.");
                log.error("SQL = 'insert into job_status(job_status_seq,status_name) values (default,?)'.");
                throw sqle;
                catch (RuntimeException re) {
                    log.error("Cannot add a job status", (Throwable)re);
                    log.error("statusName = '" + statusName + "'.");
                    log.error("SQL = 'insert into job_status(job_status_seq,status_name) values (default,?)'.");
                    throw re;
                }
            }
            catch (Throwable throwable) {
                JobDbManagerSql.safeCloseStatement(insertJobStatus);
                throw throwable;
            }
        }
        JobDbManagerSql.safeCloseStatement((Statement)insertJobStatus);
        if (log.isDebug2()) {
            log.debug2("addJobStatus(): Done.");
        }
    }

    void updateDatabaseFrom1To2(Connection conn) throws SQLException {
        String DEBUG_HEADER = "updateDatabaseFrom1To2(): ";
        if (log.isDebug2()) {
            log.debug2("updateDatabaseFrom1To2(): Starting...");
        }
        if (conn == null) {
            throw new IllegalArgumentException("Null connection");
        }
        this.addJobType(conn, "put_incremental_au");
        if (log.isDebug2()) {
            log.debug2("updateDatabaseFrom1To2(): Done.");
        }
    }

    void updateDatabaseFrom2To3(Connection conn) throws SQLException {
        log.debug2("Invoked");
        if (conn == null) {
            throw new IllegalArgumentException("Null connection");
        }
        this.createTablesIfMissing(conn, VERSION_3_TABLE_CREATE_QUERIES);
        this.insertJobQueueMetadata(conn);
        log.debug2("Done");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertJobQueueMetadata(Connection conn) throws SQLException {
        log.debug2("Invoked");
        if (conn == null) {
            throw new IllegalArgumentException("Null connection");
        }
        PreparedStatement insertJobMetadata = null;
        try {
            insertJobMetadata = this.prepareStatement(conn, INSERT_JOB_METADATA_QUERY);
            int count = this.executeUpdate(insertJobMetadata);
            if (log.isDebug3()) {
                log.debug3("count = " + count);
            }
        }
        catch (SQLException sqle) {
            try {
                log.error("Cannot add job queue metadata", (Throwable)sqle);
                log.error("SQL = 'insert into job_metadata(truncation_time) values (0)'.");
                throw sqle;
                catch (RuntimeException re) {
                    log.error("Cannot add job queue metadata", (Throwable)re);
                    log.error("SQL = 'insert into job_metadata(truncation_time) values (0)'.");
                    throw re;
                }
            }
            catch (Throwable throwable) {
                JobDbManagerSql.safeCloseStatement(insertJobMetadata);
                throw throwable;
            }
        }
        JobDbManagerSql.safeCloseStatement((Statement)insertJobMetadata);
        log.debug2("Done");
    }
}

