/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.config.TdbAu;
import org.lockss.daemon.PluginException;
import org.lockss.extractor.ArticleMetadata;
import org.lockss.extractor.ArticleMetadataExtractor;
import org.lockss.extractor.MetadataField;
import org.lockss.extractor.MetadataTarget;
import org.lockss.metadata.ArticleMetadataBuffer;
import org.lockss.metadata.MetadataDbManager;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.MetadataExtractorManagerSql;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.ArticleFiles;
import org.lockss.plugin.AuUtil;
import org.lockss.scheduler.SchedulableTask;
import org.lockss.scheduler.Schedule;
import org.lockss.scheduler.StepTask;
import org.lockss.scheduler.TaskCallback;
import org.lockss.util.LockssWatchdog;
import org.lockss.util.Logger;
import org.lockss.util.TimeInterval;
import org.lockss.util.os.PlatformUtil;
import org.lockss.util.time.TimeBase;

public class ReindexingTask
extends StepTask {
    private static Logger log = Logger.getLogger(ReindexingTask.class);
    private static final int default_steps = 10;
    private final ArchivalUnit au;
    private final ArticleMetadataExtractor ae;
    private Iterator<ArticleFiles> articleIterator = null;
    private final HashSet<Integer> auLogTable = new HashSet();
    private volatile boolean isNewAu = true;
    private volatile boolean needFullReindex = false;
    private long lastExtractTime = 0L;
    private volatile MetadataExtractorManager.ReindexingStatus status = MetadataExtractorManager.ReindexingStatus.Running;
    private volatile long indexedArticleCount = 0L;
    private volatile long updatedArticleCount = 0L;
    private volatile long startCpuTime = 0L;
    private volatile long startUserTime = 0L;
    private volatile long startClockTime = 0L;
    private volatile long startUpdateClockTime = 0L;
    private volatile long endCpuTime = 0L;
    private volatile long endUserTime = 0L;
    private volatile long endClockTime = 0L;
    private final String auName;
    private final String auId;
    private final boolean auNoSubstance;
    private ArticleMetadataBuffer articleMetadataInfoBuffer = null;
    private final MetadataDbManager dbManager;
    private final MetadataExtractorManager mdxManager;
    private final MetadataExtractorManagerSql mdxManagerSql;
    private final ArticleMetadataExtractor.Emitter emitter;
    private int extractedCount = 0;
    private LockssWatchdog watchDog;
    private static ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
    private boolean cancelled = false;

    public ReindexingTask(ArchivalUnit theAu, ArticleMetadataExtractor theAe) {
        super(new TimeInterval(TimeBase.nowMs(), TimeBase.nowMs() + 3600000L), 0L, null, null);
        this.au = theAu;
        this.ae = theAe;
        this.auName = this.au.getName();
        this.auId = this.au.getAuId();
        this.auNoSubstance = AuUtil.getAuState((ArchivalUnit)this.au).hasNoSubstance();
        this.dbManager = LockssDaemon.getLockssDaemon().getMetadataDbManager();
        this.mdxManager = (MetadataExtractorManager)((Object)LockssApp.getManagerByTypeStatic(MetadataExtractorManager.class));
        this.mdxManager.notifyStartReindexingAu(theAu);
        this.mdxManagerSql = this.mdxManager.getMetadataExtractorManagerSql();
        this.emitter = new ReindexingEmitter();
        this.callback = new ReindexingEventHandler();
    }

    public void setWDog(LockssWatchdog watchDog) {
        this.watchDog = watchDog;
    }

    public void pokeWDog() {
        this.watchDog.pokeWDog();
    }

    public void cancel() {
        String DEBUG_HEADER = "cancel(): ";
        if (log.isDebug3()) {
            log.debug3("cancel(): isFinished() = " + this.isFinished());
            log.debug3("cancel(): status = " + (Object)((Object)this.status));
        }
        this.cancelled = true;
        if (!this.isFinished() && this.status == MetadataExtractorManager.ReindexingStatus.Running) {
            this.status = MetadataExtractorManager.ReindexingStatus.Failed;
            super.cancel();
            this.setFinished();
        }
    }

    public int step(int n) {
        String DEBUG_HEADER = "step(): ";
        int steps = n <= 0 ? 10 : n;
        log.debug3("step(): step: " + steps + ", has articles: " + this.articleIterator.hasNext());
        while (!this.isFinished() && this.extractedCount <= steps && this.articleIterator.hasNext()) {
            block8: {
                log.debug3("step(): Getting the next ArticleFiles...");
                ArticleFiles af = this.articleIterator.next();
                try {
                    this.ae.extract(MetadataTarget.OpenURL(), af, this.emitter);
                }
                catch (IOException ex) {
                    log.error("Failed to index metadata for full text URL: " + af.getFullTextUrl(), (Throwable)ex);
                    this.setFinished();
                    if (this.status == MetadataExtractorManager.ReindexingStatus.Running) {
                        this.status = MetadataExtractorManager.ReindexingStatus.Rescheduled;
                        this.indexedArticleCount = 0L;
                    }
                }
                catch (PluginException ex) {
                    log.error("Failed to index metadata for full text URL: " + af.getFullTextUrl(), (Throwable)ex);
                    this.setFinished();
                    if (this.status == MetadataExtractorManager.ReindexingStatus.Running) {
                        this.status = MetadataExtractorManager.ReindexingStatus.Failed;
                        this.indexedArticleCount = 0L;
                    }
                }
                catch (RuntimeException ex) {
                    log.error(" Caught unexpected Throwable for full text URL: " + af.getFullTextUrl(), (Throwable)ex);
                    this.setFinished();
                    if (this.status != MetadataExtractorManager.ReindexingStatus.Running) break block8;
                    this.status = MetadataExtractorManager.ReindexingStatus.Failed;
                    this.indexedArticleCount = 0L;
                }
            }
            this.pokeWDog();
        }
        log.debug3("step(): isFinished() = " + this.isFinished());
        if (!this.isFinished() && !this.articleIterator.hasNext()) {
            this.setFinished();
            log.debug3("step(): isFinished() = " + this.isFinished());
        }
        log.debug3("step(): extractedCount = " + this.extractedCount);
        return this.extractedCount;
    }

    void reschedule() {
        if (!this.isFinished() && this.status == MetadataExtractorManager.ReindexingStatus.Running) {
            this.status = MetadataExtractorManager.ReindexingStatus.Rescheduled;
            super.cancel();
            this.setFinished();
        }
    }

    ArchivalUnit getAu() {
        return this.au;
    }

    String getAuName() {
        return this.auName;
    }

    public String getAuId() {
        return this.auId;
    }

    boolean hasNoAuSubstance() {
        return this.auNoSubstance;
    }

    boolean isNewAu() {
        return this.isNewAu;
    }

    boolean needsFullReindex() {
        return this.needFullReindex;
    }

    long getStartTime() {
        return this.startClockTime;
    }

    long getStartUpdateTime() {
        return this.startUpdateClockTime;
    }

    long getEndTime() {
        return this.endClockTime;
    }

    MetadataExtractorManager.ReindexingStatus getReindexingStatus() {
        return this.status;
    }

    long getIndexedArticleCount() {
        return this.indexedArticleCount;
    }

    public long getUpdatedArticleCount() {
        return this.updatedArticleCount;
    }

    public void incrementUpdatedArticleCount() {
        ++this.updatedArticleCount;
    }

    protected void handleEvent(Schedule.EventType evt) {
        this.callback.taskEvent((SchedulableTask)this, evt);
    }

    void taskWarning(String s) {
        int hashcode = s.hashCode();
        if (this.auLogTable.add(hashcode)) {
            log.warning(s);
        }
    }

    void setNewAu(boolean isNew) {
        this.isNewAu = isNew;
    }

    void setFullReindex(boolean enable) {
        this.needFullReindex = enable;
    }

    void setLastExtractTime(long time) {
        this.lastExtractTime = time;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    static /* synthetic */ long access$1802(ReindexingTask x0, long x1) {
        x0.startUpdateClockTime = x1;
        return x0.startUpdateClockTime;
    }

    static /* synthetic */ MetadataDbManager access$1900(ReindexingTask x0) {
        return x0.dbManager;
    }

    static /* synthetic */ String access$2000(ReindexingTask x0) {
        return x0.auId;
    }

    static /* synthetic */ MetadataExtractorManagerSql access$2100(ReindexingTask x0) {
        return x0.mdxManagerSql;
    }

    static /* synthetic */ long access$2200(ReindexingTask x0) {
        return x0.updatedArticleCount;
    }

    static /* synthetic */ Exception access$2302(ReindexingTask x0, Exception x1) {
        x0.e = x1;
        return x0.e;
    }

    static /* synthetic */ Exception access$2400(ReindexingTask x0) {
        return x0.e;
    }

    static /* synthetic */ Exception access$2502(ReindexingTask x0, Exception x1) {
        x0.e = x1;
        return x0.e;
    }

    static /* synthetic */ Exception access$2600(ReindexingTask x0) {
        return x0.e;
    }

    static /* synthetic */ Exception access$2702(ReindexingTask x0, Exception x1) {
        x0.e = x1;
        return x0.e;
    }

    static /* synthetic */ Exception access$2800(ReindexingTask x0) {
        return x0.e;
    }

    static /* synthetic */ long access$2902(ReindexingTask x0, long x1) {
        x0.endClockTime = x1;
        return x0.endClockTime;
    }

    static /* synthetic */ long access$3002(ReindexingTask x0, long x1) {
        x0.endCpuTime = x1;
        return x0.endCpuTime;
    }

    static /* synthetic */ long access$3102(ReindexingTask x0, long x1) {
        x0.endUserTime = x1;
        return x0.endUserTime;
    }

    static /* synthetic */ long access$1000(ReindexingTask x0) {
        return x0.startCpuTime;
    }

    static /* synthetic */ long access$1100(ReindexingTask x0) {
        return x0.startUserTime;
    }

    static /* synthetic */ long access$3000(ReindexingTask x0) {
        return x0.endCpuTime;
    }

    static /* synthetic */ long access$3100(ReindexingTask x0) {
        return x0.endUserTime;
    }

    static /* synthetic */ long access$2900(ReindexingTask x0) {
        return x0.endClockTime;
    }

    static {
        log.debug3("current thread CPU time supported? " + tmxb.isCurrentThreadCpuTimeSupported());
        if (tmxb.isCurrentThreadCpuTimeSupported()) {
            tmxb.setThreadCpuTimeEnabled(true);
        }
    }

    private class ReindexingEventHandler
    implements TaskCallback {
        private final Logger log = Logger.getLogger(ReindexingEventHandler.class);

        private ReindexingEventHandler() {
        }

        public void taskEvent(SchedulableTask task, Schedule.EventType type) {
            long threadCpuTime = 0L;
            long threadUserTime = 0L;
            long currentClockTime = TimeBase.nowMs();
            if (tmxb.isCurrentThreadCpuTimeSupported()) {
                threadCpuTime = tmxb.getCurrentThreadCpuTime();
                threadUserTime = tmxb.getCurrentThreadUserTime();
            }
            if (type == Schedule.EventType.START) {
                this.handleStartEvent(threadCpuTime, threadUserTime, currentClockTime);
            } else if (type == Schedule.EventType.FINISH) {
                this.handleFinishEvent(task, threadCpuTime, threadUserTime, currentClockTime);
            } else {
                this.log.error("Received unknown reindexing lifecycle event type '" + type + "' for AU '" + ReindexingTask.this.auName + "' - Ignored.");
            }
        }

        private void handleStartEvent(long threadCpuTime, long threadUserTime, long currentClockTime) {
            block5: {
                String DEBUG_HEADER = "handleStartEvent(): ";
                this.log.info("Starting reindexing task for AU '" + ReindexingTask.this.auName + "': isNewAu = " + ReindexingTask.this.isNewAu + ", needFullReindex = " + ReindexingTask.this.needFullReindex + "...");
                ReindexingTask.this.startCpuTime = threadCpuTime;
                ReindexingTask.this.startUserTime = threadUserTime;
                ReindexingTask.this.startClockTime = currentClockTime;
                MetadataTarget target = MetadataTarget.OpenURL();
                if (!ReindexingTask.this.isNewAu && !ReindexingTask.this.needFullReindex) {
                    if (this.log.isDebug2()) {
                        this.log.debug2("handleStartEvent(): lastExtractTime = " + ReindexingTask.this.lastExtractTime);
                    }
                    target.setIncludeFilesChangedAfter(ReindexingTask.this.lastExtractTime);
                }
                ReindexingTask.this.articleIterator = ReindexingTask.this.au.getArticleIterator(target);
                if (this.log.isDebug3()) {
                    long articleIteratorInitTime = TimeBase.nowMs() - ReindexingTask.this.startClockTime;
                    this.log.debug3("handleStartEvent(): Reindexing task for AU '" + ReindexingTask.this.auName + "': has articles? " + ReindexingTask.this.articleIterator.hasNext() + ", initializing iterator took " + articleIteratorInitTime + "ms");
                }
                try {
                    ReindexingTask.this.articleMetadataInfoBuffer = new ArticleMetadataBuffer(new File(PlatformUtil.getSystemTempDir()));
                    ReindexingTask.this.mdxManager.notifyStartReindexingAu(ReindexingTask.this.au);
                }
                catch (IOException ioe) {
                    this.log.error("Failed to set up pending AU '" + ReindexingTask.this.auName + "' for re-indexing", (Throwable)ioe);
                    ReindexingTask.this.setFinished();
                    if (ReindexingTask.this.status != MetadataExtractorManager.ReindexingStatus.Running) break block5;
                    ReindexingTask.this.status = MetadataExtractorManager.ReindexingStatus.Rescheduled;
                }
            }
        }

        /*
         * Exception decompiling
         */
        private void handleFinishEvent(SchedulableTask task, long threadCpuTime, long threadUserTime, long currentClockTime) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ReindexingEmitter
    implements ArticleMetadataExtractor.Emitter {
        private final Logger log = Logger.getLogger(ReindexingEmitter.class);

        private ReindexingEmitter() {
        }

        public void emitMetadata(ArticleFiles af, ArticleMetadata md) {
            String DEBUG_HEADER = "emitMetadata(): ";
            if (this.log.isDebug3()) {
                this.log.debug3("emitMetadata(): \n" + md.ppString(2));
            }
            HashMap<String, String> roles = new HashMap<String, String>();
            for (String key : af.getRoleMap().keySet()) {
                String value = af.getRoleAsString(key);
                if (this.log.isDebug3()) {
                    this.log.debug3("emitMetadata(): af.getRoleMap().key = " + key + ", af.getRoleUrl(key) = " + value);
                }
                roles.put(key, value);
            }
            if (this.log.isDebug3()) {
                this.log.debug3("emitMetadata(): field access url: " + md.get(MetadataField.FIELD_ACCESS_URL));
            }
            if (md.get(MetadataField.FIELD_ACCESS_URL) == null) {
                md.put(MetadataField.FIELD_ACCESS_URL, af.getFullTextUrl());
            }
            md.putRaw(MetadataField.FIELD_FEATURED_URL_MAP.getKey(), roles);
            long fetchTime = AuUtil.getAuUrlsEarliestFetchTime((ArchivalUnit)ReindexingTask.this.au, roles.values());
            if (this.log.isDebug3()) {
                this.log.debug3("emitMetadata(): fetchTime = " + fetchTime);
            }
            md.put(MetadataField.FIELD_FETCH_TIME, String.valueOf(fetchTime));
            try {
                this.validateDataAgainstTdb(new ArticleMetadataBuffer.ArticleMetadataInfo(md), ReindexingTask.this.au);
                ReindexingTask.this.articleMetadataInfoBuffer.add(md);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            ReindexingTask.this.extractedCount++;
            ReindexingTask.this.indexedArticleCount++;
        }

        private void validateDataAgainstTdb(ArticleMetadataBuffer.ArticleMetadataInfo mdinfo, ArchivalUnit au) {
            HashSet<String> isbns = new HashSet<String>();
            if (mdinfo.getIsbn() != null) {
                isbns.add(mdinfo.getIsbn());
            }
            if (mdinfo.getEisbn() != null) {
                isbns.add(mdinfo.getEisbn());
            }
            HashSet<String> issns = new HashSet<String>();
            if (mdinfo.getIssn() != null) {
                issns.add(mdinfo.getIssn());
            }
            if (mdinfo.getEissn() != null) {
                issns.add(mdinfo.getEissn());
            }
            TdbAu tdbau = au.getTdbAu();
            boolean isTitleInTdb = !au.isBulkContent();
            String tdbauName = tdbau == null ? null : tdbau.getName();
            String tdbauStartYear = tdbau == null ? ReindexingTask.this.auName : tdbau.getStartYear();
            String tdbauYear = tdbau == null ? null : tdbau.getYear();
            String tdbauIsbn = null;
            String tdbauIssn = null;
            String tdbauEissn = null;
            String tdbauJournalTitle = null;
            if (isTitleInTdb && tdbau != null) {
                tdbauIsbn = tdbau.getIsbn();
                tdbauIssn = tdbau.getPrintIssn();
                tdbauEissn = tdbau.getEissn();
                tdbauJournalTitle = tdbau.getPublicationTitle();
            }
            if (tdbau != null) {
                if (tdbauJournalTitle != null && !tdbauJournalTitle.equals(mdinfo.getPublicationTitle())) {
                    if (mdinfo.getPublicationTitle() == null) {
                        ReindexingTask.this.taskWarning("tdb title  is " + tdbauJournalTitle + " for " + tdbauName + " -- metadata title is missing");
                    } else {
                        ReindexingTask.this.taskWarning("tdb title " + tdbauJournalTitle + " for " + tdbauName + " -- does not match metadata journal title " + mdinfo.getPublicationTitle());
                    }
                }
                if (tdbauIsbn != null) {
                    if (!tdbauIsbn.equals(mdinfo.getIsbn())) {
                        isbns.add(tdbauIsbn);
                        if (mdinfo.getIsbn() == null) {
                            ReindexingTask.this.taskWarning("using tdb isbn " + tdbauIsbn + " for " + tdbauName + " -- metadata isbn missing");
                        } else {
                            ReindexingTask.this.taskWarning("also using tdb isbn " + tdbauIsbn + " for " + tdbauName + " -- different than metadata isbn: " + mdinfo.getIsbn());
                        }
                    } else if (mdinfo.getIsbn() != null) {
                        ReindexingTask.this.taskWarning("tdb isbn missing for " + tdbauName + " -- should be: " + mdinfo.getIsbn());
                    }
                } else if (mdinfo.getIsbn() != null && isTitleInTdb) {
                    ReindexingTask.this.taskWarning("tdb isbn missing for " + tdbauName + " -- should be: " + mdinfo.getIsbn());
                }
                if (tdbauIssn != null) {
                    if (tdbauIssn.equals(mdinfo.getEissn()) && mdinfo.getIssn() == null) {
                        ReindexingTask.this.taskWarning("tdb print issn " + tdbauIssn + " for " + tdbauName + " -- reported by metadata as eissn");
                    } else if (!tdbauIssn.equals(mdinfo.getIssn())) {
                        issns.add(tdbauIssn);
                        if (mdinfo.getIssn() == null) {
                            ReindexingTask.this.taskWarning("using tdb print issn " + tdbauIssn + " for " + tdbauName + " -- metadata print issn is missing");
                        } else {
                            ReindexingTask.this.taskWarning("also using tdb print issn " + tdbauIssn + " for " + tdbauName + " -- different than metadata print issn: " + mdinfo.getIssn());
                        }
                    }
                } else if (mdinfo.getIssn() != null) {
                    if (mdinfo.getIssn().equals(tdbauEissn)) {
                        ReindexingTask.this.taskWarning("tdb eissn " + tdbauEissn + " for " + tdbauName + " -- reported by metadata as print issn");
                    } else if (isTitleInTdb) {
                        ReindexingTask.this.taskWarning("tdb issn missing for " + tdbauName + " -- should be: " + mdinfo.getIssn());
                    }
                }
                if (tdbauEissn != null) {
                    if (tdbauEissn.equals(mdinfo.getIssn()) && mdinfo.getEissn() == null) {
                        ReindexingTask.this.taskWarning("tdb eissn " + tdbauEissn + " for " + tdbauName + " -- reported by metadata as print issn");
                    } else if (!tdbauEissn.equals(mdinfo.getEissn())) {
                        issns.add(tdbauEissn);
                        if (mdinfo.getEissn() == null) {
                            ReindexingTask.this.taskWarning("using tdb eissn " + tdbauEissn + " for " + tdbauName + " -- metadata eissn is missing");
                        } else {
                            ReindexingTask.this.taskWarning("also using tdb eissn " + tdbauEissn + " for " + tdbauName + " -- different than metadata eissn: " + mdinfo.getEissn());
                        }
                    }
                } else if (mdinfo.getEissn() != null) {
                    if (mdinfo.getEissn().equals(tdbauIssn)) {
                        ReindexingTask.this.taskWarning("tdb print issn " + tdbauIssn + " for " + tdbauName + " -- reported by metadata as print eissn");
                    } else if (isTitleInTdb) {
                        ReindexingTask.this.taskWarning("tdb eissn missing for " + tdbauName + " -- should be: " + mdinfo.getEissn());
                    }
                }
                String pubYear = mdinfo.getPubYear();
                if (pubYear != null) {
                    if (!tdbau.includesYear(mdinfo.getPubYear())) {
                        if (tdbauYear != null) {
                            ReindexingTask.this.taskWarning("tdb year " + tdbauYear + " for " + tdbauName + " -- does not match metadata year " + pubYear);
                        } else {
                            ReindexingTask.this.taskWarning("tdb year missing for " + tdbauName + " -- should include year " + pubYear);
                        }
                    }
                } else {
                    pubYear = tdbauStartYear;
                    if (mdinfo.getPubYear() != null) {
                        ReindexingTask.this.taskWarning("using tdb start year " + mdinfo.getPubYear() + " for " + tdbauName + " -- metadata year is missing");
                    }
                }
            }
        }
    }
}

