/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.metadata.extractor;

import java.sql.Connection;
import java.util.ArrayList;
import org.lockss.app.LockssDaemon;
import org.lockss.config.ConfigManager;
import org.lockss.config.Configuration;
import org.lockss.daemon.LockssRunnable;
import org.lockss.db.DbException;
import org.lockss.metadata.MetadataDbManager;
import org.lockss.metadata.extractor.MetadataExtractorManager;
import org.lockss.metadata.extractor.job.JobAuStatus;
import org.lockss.metadata.extractor.job.JobManager;
import org.lockss.plugin.ArchivalUnit;
import org.lockss.plugin.AuEvent;
import org.lockss.plugin.AuEventHandler;
import org.lockss.plugin.AuUtil;
import org.lockss.plugin.PluginManager;
import org.lockss.util.CollectionUtil;
import org.lockss.util.Logger;
import org.lockss.util.time.TimeBase;

public class MetadataIndexingStarter
extends LockssRunnable {
    private static Logger log = Logger.getLogger(MetadataIndexingStarter.class);
    private final MetadataDbManager dbManager;
    private final MetadataExtractorManager mdxManager;
    private final PluginManager pluginManager;
    private final JobManager jobManager;
    private final long metadataExtractionCheckInterval;

    public MetadataIndexingStarter(MetadataDbManager dbManager, MetadataExtractorManager mdxManager, PluginManager pluginManager, JobManager jobManager, long metadataExtractionCheckInterval) {
        super("MetadataStarter");
        this.dbManager = dbManager;
        this.mdxManager = mdxManager;
        this.pluginManager = pluginManager;
        this.jobManager = jobManager;
        this.metadataExtractionCheckInterval = metadataExtractionCheckInterval;
    }

    public void lockssRun() {
        String DEBUG_HEADER = "lockssRun(): ";
        log.debug("lockssRun(): Starting...");
        LockssDaemon daemon = LockssDaemon.getLockssDaemon();
        if (!daemon.areAusStarted()) {
            log.debug("lockssRun(): Waiting for aus to start");
            while (!daemon.areAusStarted()) {
                try {
                    daemon.waitUntilAusStarted();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (log.isDebug3()) {
            log.debug3("lockssRun(): Registering ArchivalUnitEventHandler...");
        }
        this.pluginManager.registerAuEventHandler((AuEventHandler)new ArchivalUnitEventHandler());
        if (log.isDebug3()) {
            log.debug3("lockssRun(): Done registering ArchivalUnitEventHandler.");
        }
        if (log.isDebug3()) {
            log.debug3("lockssRun(): Registering ArchivalUnitConfigurationCallback...");
        }
        ConfigManager.getConfigManager().registerConfigurationCallback((Configuration.Callback)new ArchivalUnitConfigurationCallback());
        if (log.isDebug3()) {
            log.debug3("lockssRun(): Done registering ArchivalUnitConfigurationCallback.");
        }
        while (true) {
            long delay;
            long beforeTimestamp = TimeBase.nowMs();
            this.scheduleNeededMetadataExtractionJobs();
            long intervalLeft = this.metadataExtractionCheckInterval - (TimeBase.nowMs() - beforeTimestamp);
            long l = delay = intervalLeft >= 0L ? intervalLeft : 0L;
            if (log.isDebug3()) {
                log.debug3("Sleeping for " + delay + " ms...");
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!log.isDebug3()) continue;
            log.debug3("Back from sleep.");
        }
    }

    private void scheduleNeededMetadataExtractionJobs() {
        Connection conn;
        String DEBUG_HEADER = "scheduleNeededMetadataExtractionJobs(): ";
        log.debug2("scheduleNeededMetadataExtractionJobs(): Starting...");
        try {
            conn = this.dbManager.getConnection();
        }
        catch (DbException dbe) {
            log.error("Cannot connect to database -- extraction not started", (Throwable)dbe);
            return;
        }
        log.debug2("scheduleNeededMetadataExtractionJobs(): Examining AUs");
        ArrayList<ArchivalUnit> toBeIndexed = new ArrayList<ArchivalUnit>();
        for (ArchivalUnit au : this.pluginManager.getAllAus()) {
            if (log.isDebug3()) {
                log.debug3("scheduleNeededMetadataExtractionJobs(): Plugin AU = " + au.getName());
            }
            if (!AuUtil.hasCrawled((ArchivalUnit)au)) {
                if (!log.isDebug3()) continue;
                log.debug3("scheduleNeededMetadataExtractionJobs(): AU has not been crawled: No indexing.");
                continue;
            }
            try {
                if (this.mdxManager.isAuMetadataForObsoletePlugin(conn, au) || this.mdxManager.isAuCrawledAndNotExtracted(conn, au)) {
                    if (log.isDebug3()) {
                        log.debug3("scheduleNeededMetadataExtractionJobs(): AU is to be indexed");
                    }
                    toBeIndexed.add(au);
                    continue;
                }
                if (!log.isDebug3()) continue;
                log.debug3("scheduleNeededMetadataExtractionJobs(): AU does not need to be indexed");
            }
            catch (DbException dbe) {
                log.error("Cannot get AU metadata version: " + (Object)((Object)dbe));
            }
        }
        log.debug2("scheduleNeededMetadataExtractionJobs(): Done examining AUs");
        for (ArchivalUnit au : CollectionUtil.randomPermutation(toBeIndexed)) {
            if (log.isDebug3()) {
                log.debug3("scheduleNeededMetadataExtractionJobs(): Pending AU = " + au.getName());
            }
            String auId = au.getAuId();
            if (log.isDebug3()) {
                log.debug3("scheduleNeededMetadataExtractionJobs(): auId = " + auId);
            }
            try {
                this.mdxManager.scheduleMetadataExtraction(au, auId);
            }
            catch (Exception e) {
                log.error("Cannot reindex metadata for " + auId, (Throwable)e);
                return;
            }
        }
        if (log.isDebug2()) {
            log.debug2("scheduleNeededMetadataExtractionJobs(): Done.");
        }
    }

    private class ArchivalUnitConfigurationCallback
    implements Configuration.Callback {
        private ArchivalUnitConfigurationCallback() {
        }

        public void configurationChanged(Configuration newConfig, Configuration oldConfig, Configuration.Differences changes) {
            if (log.isDebug2()) {
                log.debug2("Ignored");
            }
        }

        public void auConfigChanged(String auId) {
            if (log.isDebug2()) {
                log.debug2("Ignored");
            }
        }

        public void auConfigRemoved(String auId) {
            if (log.isDebug2()) {
                log.debug2("auId = " + auId);
            }
            try {
                MetadataIndexingStarter.this.mdxManager.persistUnconfiguredAu(auId);
                JobAuStatus jobAuStatus = MetadataIndexingStarter.this.jobManager.scheduleMetadataRemoval(auId);
                log.info("Scheduled metadata removal job: " + jobAuStatus);
            }
            catch (Exception e) {
                log.error("Cannot delete metadata for " + auId, (Throwable)e);
            }
            if (log.isDebug2()) {
                log.debug2("Done");
            }
        }
    }

    private class ArchivalUnitEventHandler
    extends AuEventHandler.Base {
        private ArchivalUnitEventHandler() {
        }

        public void auCreated(AuEvent event, String auId, ArchivalUnit au) {
            if (log.isDebug2()) {
                log.debug2("Ignored because it is handled by ArchivalUnitConfigurationCallback.auConfigChanged()");
            }
        }

        public void auDeleted(AuEvent event, String auId, ArchivalUnit au) {
            if (log.isDebug2()) {
                log.debug2("Ignored");
            }
        }

        public void auContentChanged(AuEvent event, String auId, ArchivalUnit au, AuEvent.ContentChangeInfo info) {
            if (log.isDebug2()) {
                log.debug2("event = " + event + ", auId = " + auId + ", au = " + au + ", info = " + info);
            }
            switch (event.getType()) {
                case ContentChanged: {
                    if (log.isDebug3()) {
                        log.debug3("ContentChanged for auId: " + auId);
                        log.debug3("info.isComplete() = " + info.isComplete());
                    }
                    if (info.isComplete()) {
                        try {
                            MetadataIndexingStarter.this.mdxManager.scheduleMetadataExtraction(au, auId);
                        }
                        catch (Exception e) {
                            log.error("Cannot reindex metadata for " + auId, (Throwable)e);
                        }
                        break;
                    }
                    if (!log.isDebug3()) break;
                    log.debug3("Skipping because info.isComplete() is false");
                    break;
                }
            }
            if (log.isDebug2()) {
                log.debug2("Done.");
            }
        }
    }
}

