/*
 * Decompiled with CFR 0.152.
 */
package org.josql.utils;

import java.util.ArrayList;
import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.Expression;

public class ExpressionEvaluator {
    private Expression where = null;
    private Query q = null;

    public ExpressionEvaluator(String exp, Class cl) throws QueryParseException {
        this(exp, cl, null);
    }

    public ExpressionEvaluator(String exp, Class cl, List fhs) throws QueryParseException {
        Query q = new Query();
        if (fhs != null) {
            for (int i = 0; i < fhs.size(); ++i) {
                q.addFunctionHandler(fhs.get(i));
            }
        }
        q.parse("SELECT * FROM " + cl.getName() + " WHERE " + exp);
        this.q = q;
        this.where = q.getWhereClause();
    }

    public Query getQuery() {
        return this.q;
    }

    public boolean isTrue(Object o) throws QueryExecutionException {
        if (o == null) {
            throw new NullPointerException("Object passed in is null.");
        }
        return this.where.isTrue(o, this.q);
    }

    public List getValues(List l) throws QueryExecutionException {
        if (l == null) {
            throw new NullPointerException("List is null");
        }
        int s = l.size();
        ArrayList<Object> ret = new ArrayList<Object>(s);
        for (int i = s - 1; i > -1; --i) {
            ret.set(i, this.getValue(l.get(i)));
        }
        return ret;
    }

    public Object getValue(Object o) throws QueryExecutionException {
        return this.where.getValue(o, this.q);
    }

    public static boolean isTrue(String exp, Object o) throws QueryParseException, QueryExecutionException {
        if (o == null) {
            throw new NullPointerException("Object passed in is null.");
        }
        ExpressionEvaluator ee = new ExpressionEvaluator(exp, o.getClass());
        return ee.isTrue(o);
    }

    public static List getValues(String exp, List l) throws QueryParseException, QueryExecutionException {
        Object o;
        if (l == null) {
            throw new NullPointerException("List is null");
        }
        if (l.size() == 0) {
            return new ArrayList();
        }
        Class<?> c = null;
        for (int i = 0; i < l.size() && ((o = l.get(i)) == null || (c = o.getClass()) == null); ++i) {
        }
        if (c == null) {
            throw new NullPointerException("All objects in the list are null");
        }
        ExpressionEvaluator ee = new ExpressionEvaluator(exp, c);
        return ee.getValues(l);
    }

    public static Object getValue(String exp, Object o) throws QueryParseException, QueryExecutionException {
        if (o == null) {
            throw new NullPointerException("Object passed in is null.");
        }
        ExpressionEvaluator ee = new ExpressionEvaluator(exp, o.getClass());
        return ee.getValue(o);
    }
}

