/*
 * Decompiled with CFR 0.152.
 */
package org.josql.internal;

import com.gentlyweb.utils.FilterException;
import com.gentlyweb.utils.GeneralFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodFilter {
    private Class c = null;
    private List ps = null;
    private String name = null;
    private int type = -1;
    private List modifiers = null;

    public MethodFilter() {
    }

    public MethodFilter(Class c) {
        this.c = c;
    }

    public void setClass(Class c) {
        this.c = c;
    }

    public void addModifier(int m) {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList();
        }
        this.modifiers.add(m);
    }

    public List filter() throws IllegalAccessException, InvocationTargetException, FilterException {
        Method[] ms = this.c.getMethods();
        ArrayList<Method> res = new ArrayList<Method>();
        if (ms.length == 0) {
            return res;
        }
        GeneralFilter gf = null;
        if (this.name != null) {
            gf = new GeneralFilter(Method.class);
            gf.addField("name", this.name, this.type);
        }
        for (int i = 0; i < ms.length; ++i) {
            Method m = ms[i];
            if (gf != null && !gf.accept(m) || !this.hasModifiers(m) || !this.hasParameters(m)) continue;
            res.add(m);
        }
        return res;
    }

    private boolean hasParameters(Method m) {
        if (this.ps == null) {
            return true;
        }
        Class<?>[] mpt = m.getParameterTypes();
        if (mpt.length != this.ps.size()) {
            return false;
        }
        for (int i = 0; i < mpt.length; ++i) {
            Class<?> c = mpt[i];
            Class pc = (Class)this.ps.get(i);
            if (pc == null || c.isAssignableFrom(pc)) continue;
            return false;
        }
        return true;
    }

    private boolean hasModifiers(Method m) {
        if (this.modifiers != null) {
            int mmods = m.getModifiers();
            for (int i = 0; i < this.modifiers.size(); ++i) {
                int in = (Integer)this.modifiers.get(i);
                if ((mmods & in) != 0) continue;
                return false;
            }
        }
        return true;
    }

    public void setParameterTypes(List pt) {
        this.ps = pt;
    }

    public void setName(String n, int type) {
        this.name = n;
        this.type = type;
    }
}

