/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions.regexp;

import java.util.HashMap;
import java.util.Map;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.functions.regexp.ApacheRegExpWrapper;
import org.josql.functions.regexp.GNURegExpWrapper;
import org.josql.functions.regexp.OroApacheRegExpWrapper;
import org.josql.functions.regexp.RegExp;
import org.josql.functions.regexp.StandardJavaRegExpWrapper;

public class RegExpFactory {
    public static final String JAVA_INST = "java";
    public static final String ORO_INST = "oro";
    public static final String GNU_INST = "gnu";
    public static final String APACHE_REGEXP_INST = "apache.regexp";
    private String defInst = "java";
    private Map mappings = new HashMap();
    private Map versions = new HashMap();

    public RegExpFactory(Query q) {
        ApacheRegExpWrapper a;
        GNURegExpWrapper g;
        OroApacheRegExpWrapper o;
        StandardJavaRegExpWrapper j = new StandardJavaRegExpWrapper();
        if (j.isAvailable(q)) {
            this.mappings.put(JAVA_INST, StandardJavaRegExpWrapper.class);
            this.versions.put(JAVA_INST, j.getSupportedVersion());
        }
        if ((o = new OroApacheRegExpWrapper()).isAvailable(q)) {
            this.mappings.put(ORO_INST, OroApacheRegExpWrapper.class);
            this.versions.put(ORO_INST, o.getSupportedVersion());
        }
        if ((g = new GNURegExpWrapper()).isAvailable(q)) {
            this.mappings.put(GNU_INST, GNURegExpWrapper.class);
            this.versions.put(GNU_INST, g.getSupportedVersion());
        }
        if ((a = new ApacheRegExpWrapper()).isAvailable(q)) {
            this.mappings.put(APACHE_REGEXP_INST, ApacheRegExpWrapper.class);
            this.versions.put(APACHE_REGEXP_INST, a.getSupportedVersion());
        }
    }

    public String getSupportedVersion(String instName) {
        return (String)this.versions.get(instName);
    }

    public String getDefaultInstanceName() {
        return this.defInst;
    }

    public void addInstance(String name, RegExp re, boolean def) {
        this.mappings.put(name, re);
        if (def) {
            this.defInst = name;
        }
    }

    public void setDefaultInstanceName(String n) {
        if (!this.mappings.containsKey(n)) {
            throw new IllegalArgumentException("No appropriate wrapper class found for instance name: " + n);
        }
        this.defInst = n;
    }

    public RegExp getDefaultInstance(Query q) throws QueryExecutionException {
        return this.getInstance(this.defInst, q);
    }

    public RegExp getInstance(String type, Query q) throws QueryExecutionException {
        Object o = this.mappings.get(type);
        if (o == null) {
            return null;
        }
        if (o instanceof RegExp) {
            return (RegExp)o;
        }
        Class c = (Class)o;
        try {
            RegExp re = (RegExp)c.newInstance();
            re.init(q);
            this.mappings.put(type, re);
            return re;
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init RegExp instance: " + c.getName(), e);
        }
    }
}

