/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import com.gentlyweb.utils.Getter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.Expression;
import org.josql.expressions.ValueExpression;
import org.josql.functions.NotFixedResults;
import org.josql.internal.Utilities;

public class Function
extends ValueExpression {
    private String name = null;
    private List params = null;
    private Method function = null;
    private Object handler = null;
    private boolean fixedResult = true;
    private Object fixedValue = null;
    private String acc = null;
    private Getter get = null;

    public Getter getGetter() {
        return this.get;
    }

    public String getAccessor() {
        return this.acc;
    }

    public void setAccessor(String acc) {
        this.acc = acc;
    }

    @Override
    public Class getExpectedReturnType(Query q) {
        if (this.get != null) {
            return this.get.getType();
        }
        return this.function.getReturnType();
    }

    @Override
    public void init(Query q) throws QueryParseException {
        if (this.params != null) {
            int s = this.params.size();
            for (int i = 0; i < s; ++i) {
                Expression exp = (Expression)this.params.get(i);
                exp.init(q);
            }
        }
        this.findMethod(q);
        if (this.function == null) {
            Class[] ps = null;
            if (this.params != null) {
                int s = this.params.size();
                ps = new Class[s];
                for (int i = 0; i < s; ++i) {
                    Expression exp = (Expression)this.params.get(i);
                    ps[i] = exp.getExpectedReturnType(q);
                }
            }
            throw new QueryParseException("Unable to find function (method): \"" + Utilities.formatSignature(this.name, ps) + "\" in any user-defined function handlers or the default function handler");
        }
        if (this.acc != null) {
            this.initAccessor();
        }
        if (this.params != null && !NotFixedResults.class.isAssignableFrom(this.function.getDeclaringClass())) {
            for (int i = 0; i < this.params.size(); ++i) {
                Expression exp = (Expression)this.params.get(i);
                if (exp.hasFixedResult(q)) continue;
                this.fixedResult = false;
                break;
            }
        } else {
            this.fixedResult = false;
        }
    }

    private void initAccessor() throws QueryParseException {
        Class<?> retType = this.function.getReturnType();
        if (Void.TYPE.isAssignableFrom(retType)) {
            throw new QueryParseException("Function: " + this + " maps to method: " + this.function + " however methods return type is \"void\" and an accessor: " + this.acc + " has been defined.");
        }
        if (!retType.getName().equals(Object.class.getName())) {
            try {
                this.get = new Getter(this.acc, retType);
            }
            catch (Exception e) {
                throw new QueryParseException("Function: " + this + " maps to method: " + this.function + " and has accessor: " + this.acc + " however no valid accessor has been found in return type: " + retType.getName(), e);
            }
        }
    }

    private void getMethodFromHandlers(Query q, List handlers) throws QueryParseException {
        int s = handlers.size();
        TreeMap ms = new TreeMap();
        for (int i = 0; i < s; ++i) {
            Object fh = handlers.get(i);
            this.getMethods(fh.getClass(), q, ms);
        }
        if (ms.size() > 0) {
            this.function = (Method)ms.get(ms.lastKey());
            Class<?> c = this.function.getDeclaringClass();
            for (int i = 0; i < s; ++i) {
                Object o = handlers.get(i);
                if (!o.getClass().isAssignableFrom(c)) continue;
                this.handler = o;
            }
        }
    }

    private void findMethod(Query q) throws QueryParseException {
        List dfhs;
        List fhs = q.getFunctionHandlers();
        if (fhs != null) {
            this.getMethodFromHandlers(q, fhs);
        }
        if (this.function == null && (dfhs = q.getDefaultFunctionHandlers()) != null) {
            this.getMethodFromHandlers(q, dfhs);
        }
    }

    public List getParameters() {
        return this.params;
    }

    public void setParameters(List ps) {
        this.params = ps;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object evaluate(Object o, Query q) throws QueryExecutionException {
        if (this.fixedResult && this.fixedValue != null) {
            return this.fixedValue;
        }
        Object[] ps = null;
        if (this.params != null) {
            int s = this.params.size();
            ps = new Object[s];
            for (int i = 0; i < s; ++i) {
                Expression exp = (Expression)this.params.get(i);
                if (Expression.class.isAssignableFrom(this.function.getParameterTypes()[i])) {
                    ps[i] = exp;
                    continue;
                }
                try {
                    ps[i] = exp.getValue(o, q);
                    continue;
                }
                catch (Exception e) {
                    throw new QueryExecutionException("Unable to get parameter: " + i + " (\"" + exp.toString() + "\") for function: " + this.name, e);
                }
            }
        }
        Object v = null;
        try {
            v = this.function.invoke(this.handler, ps);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to execute function: " + this.name + " (\"" + this.toString() + "\") with values: " + Arrays.asList(ps), e);
        }
        if (v != null && this.acc != null) {
            if (this.get == null) {
                try {
                    this.get = new Getter(this.acc, v.getClass());
                }
                catch (Exception e) {
                    throw new QueryExecutionException("Unable to create accessor for: " + this.acc + " from return type: " + v.getClass().getName() + " after execution of function: " + this, e);
                }
            }
            try {
                v = this.get.getValue(v);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value for accessor: " + this.acc + " from return type: " + v.getClass().getName() + " after execution of function: " + this, e);
            }
        }
        if (this.fixedResult) {
            this.fixedValue = v;
        }
        return v;
    }

    @Override
    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        if ((o = this.evaluate(o, q)) == null) {
            return false;
        }
        if (Utilities.isNumber(o)) {
            return Utilities.getDouble(o) > 0.0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append("(");
        if (this.params != null) {
            for (int i = 0; i < this.params.size(); ++i) {
                Expression p = (Expression)this.params.get(i);
                buf.append(p);
                if (i >= this.params.size() - 1) continue;
                buf.append(",");
            }
        }
        buf.append(")");
        if (this.acc != null) {
            buf.append(".");
            buf.append(this.acc);
        }
        if (this.isBracketed()) {
            buf.insert(0, "(");
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public boolean hasFixedResult(Query q) {
        return this.fixedResult;
    }

    private int matchMethodArgs(Class[] methArgs, Query q) throws QueryParseException {
        int score = 0;
        for (int i = 0; i < methArgs.length; ++i) {
            Class c = methArgs[i];
            Expression exp = (Expression)this.params.get(i);
            if (c.getClass().getName().equals(Object.class.getName())) {
                ++score;
                continue;
            }
            Class expC = exp.getExpectedReturnType(q);
            if (expC == null) continue;
            if (c.isAssignableFrom(expC)) {
                score += 2;
                continue;
            }
            if (Expression.class.isAssignableFrom(c)) {
                ++score;
                continue;
            }
            if (Utilities.isNumber(expC) && (Utilities.isNumber(c) || c.getName().equals(Object.class.getName()))) {
                ++score;
                continue;
            }
            if (Utilities.isPrimitiveClass(c) && Utilities.isPrimitiveClass(expC) && Utilities.getPrimitiveClass(c).isAssignableFrom(Utilities.getPrimitiveClass(expC))) {
                ++score;
                continue;
            }
            if (expC.getName().equals(Object.class.getName())) {
                ++score;
                continue;
            }
            return 0;
        }
        return score;
    }

    private void getMethods(Class c, Query q, Map matches) throws QueryParseException {
        Method[] meths = c.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            if (!m.getName().equals(this.name) || !Modifier.isPublic(m.getModifiers())) continue;
            Class[] mpt = m.getParameterTypes();
            int ps = 0;
            int fps = 0;
            if (mpt != null) {
                ps = mpt.length;
            }
            if (this.params != null) {
                fps = this.params.size();
            }
            if (ps != fps) continue;
            if (ps == 0) {
                matches.put(0, m);
                return;
            }
            int score = this.matchMethodArgs(mpt, q);
            if (score <= 0) continue;
            matches.put(score, m);
        }
    }
}

