/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.expressions.BinaryExpression;
import org.josql.internal.Utilities;

public class EqualsExpression
extends BinaryExpression {
    private boolean not = false;
    public boolean ignoreCase = false;

    public void setIgnoreCase(boolean v) {
        this.ignoreCase = v;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean v) {
        this.not = v;
    }

    @Override
    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        Object l = null;
        try {
            l = this.left.getValue(o, q);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to get value for LHS of expression: " + this, e);
        }
        Object r = null;
        try {
            r = this.right.getValue(o, q);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to get value for RHS of expression: " + this, e);
        }
        if (l == null && r == null) {
            return !this.not;
        }
        if (l == null || r == null) {
            return this.not;
        }
        return Utilities.matches(l, r, this.ignoreCase, 4, this.not);
    }

    @Override
    public String toString() {
        String pred = "=";
        if (this.not) {
            pred = "!=";
        }
        if (this.ignoreCase) {
            pred = "$" + pred;
        }
        if (this.isBracketed()) {
            return "(" + this.left.toString() + " " + pred + " " + this.right.toString() + ")";
        }
        return this.left.toString() + " " + pred + " " + this.right.toString();
    }
}

