/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.ValueExpression;
import org.josql.internal.Utilities;

public class ArithmeticExpression
extends ValueExpression {
    public static final int MULTIPLY = 0;
    public static final int ADDITION = 1;
    public static final int SUBTRACT = 2;
    public static final int DIVIDE = 3;
    public static final int MODULUS = 4;
    private int type = -1;
    private ValueExpression left = null;
    private ValueExpression right = null;
    private boolean fixedResult = false;

    @Override
    public Class getExpectedReturnType(Query q) throws QueryParseException {
        return this.left.getExpectedReturnType(q);
    }

    @Override
    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        if ((o = this.evaluate(o, q)) == null) {
            return false;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() > 0.0;
        }
        return true;
    }

    @Override
    public boolean hasFixedResult(Query q) {
        return this.fixedResult;
    }

    @Override
    public void init(Query q) throws QueryParseException {
        this.left.init(q);
        this.right.init(q);
        this.fixedResult = this.left.hasFixedResult(q) && this.right.hasFixedResult(q);
    }

    public ValueExpression getRight() {
        return this.right;
    }

    public ValueExpression getLeft() {
        return this.left;
    }

    public void setLeft(ValueExpression exp) {
        this.left = exp;
    }

    public void setRight(ValueExpression exp) {
        this.right = exp;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    @Override
    public Object evaluate(Object o, Query q) throws QueryExecutionException {
        Object l = this.left.getValue(o, q);
        Object r = this.right.getValue(o, q);
        if (!(this.type != 1 || l instanceof Number && r instanceof Number)) {
            StringBuffer b = new StringBuffer();
            b.append(l);
            b.append(r);
            return b.toString();
        }
        if (l == null) {
            l = new Double(0.0);
        }
        if (r == null) {
            r = new Double(0.0);
        }
        double ld = Utilities.getDouble(l);
        double rd = Utilities.getDouble(r);
        if (this.type == 1) {
            return new Double(ld + rd);
        }
        if (this.type == 2) {
            return new Double(ld - rd);
        }
        if (this.type == 0) {
            return new Double(ld * rd);
        }
        if (this.type == 4) {
            return new Double(ld % rd);
        }
        if (this.type == 3) {
            if (rd == 0.0) {
                return new Double(0.0);
            }
            return new Double(ld / rd);
        }
        return null;
    }

    @Override
    public String toString() {
        String pred = "+";
        if (this.type == 0) {
            pred = "*";
        }
        if (this.type == 2) {
            pred = "-";
        }
        if (this.type == 4) {
            pred = "%";
        }
        if (this.type == 3) {
            pred = "/";
        }
        String exp = this.left.toString() + " " + pred + " " + this.right.toString();
        if (this.isBracketed()) {
            exp = "(" + exp + ")";
        }
        return exp;
    }
}

