/*
 * Decompiled with CFR 0.152.
 */
package org.josql.contrib;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;
import org.josql.expressions.SelectItemExpression;
import org.josql.internal.Utilities;

public class JoSQLSwingTableModel
extends Query
implements TableModel {
    private QueryResults results = null;
    private List listeners = new ArrayList();

    @Override
    public void parse(String sql) throws QueryParseException {
        this.results = null;
        super.parse(sql);
        if (this.isWantObjects()) {
            throw new QueryParseException("Only SQL statements that return columns (not the objects passed in) can be used.");
        }
        this.notifyListeners(new TableModelEvent(this, -1));
    }

    private void notifyListeners(TableModelEvent ev) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TableModelListener l = (TableModelListener)this.listeners.get(i);
            l.tableChanged(ev);
        }
    }

    @Override
    public QueryResults reorder(List objs, SortedMap dirs) throws QueryExecutionException, QueryParseException {
        this.results = super.reorder(objs, dirs);
        this.notifyListeners(new TableModelEvent(this));
        return this.results;
    }

    @Override
    public QueryResults reorder(List objs, String orderBys) throws QueryParseException, QueryExecutionException {
        this.results = super.reorder(objs, orderBys);
        this.notifyListeners(new TableModelEvent(this));
        return this.results;
    }

    @Override
    public QueryResults execute(List l) throws QueryExecutionException {
        this.results = super.execute(l);
        this.notifyListeners(new TableModelEvent(this));
        return this.results;
    }

    public QueryResults getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results = null;
    }

    @Override
    public String getColumnName(int ind) {
        List cs = this.getColumns();
        if (cs == null || ind > cs.size() - 1) {
            return null;
        }
        SelectItemExpression s = (SelectItemExpression)cs.get(ind);
        String al = s.getAlias();
        if (al == null) {
            return ind + 1 + "";
        }
        return al;
    }

    public Class getColumnClass(int i) {
        List cs = this.getColumns();
        if (cs == null || i > cs.size() - 1) {
            return null;
        }
        SelectItemExpression s = (SelectItemExpression)cs.get(i);
        try {
            return Utilities.getObjectClass(s.getExpectedReturnType(this));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (this.results == null || r > this.results.getResults().size() - 1) {
            return null;
        }
        Object o = this.results.getResults().get(r);
        if (o instanceof List) {
            List l = (List)o;
            if (c > l.size() - 1) {
                return null;
            }
            return l.get(c);
        }
        if (c > 0) {
            return null;
        }
        return o;
    }

    @Override
    public void setValueAt(Object v, int r, int c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not supported for: " + this.getClass().getName());
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public int getRowCount() {
        if (this.results == null) {
            return 0;
        }
        return this.results.getResults().size();
    }

    @Override
    public int getColumnCount() {
        if (this.getColumns() == null) {
            return 0;
        }
        return this.getColumns().size();
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }
}

