/*
 * Decompiled with CFR 0.152.
 */
package org.josql.contrib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;
import org.josql.expressions.SelectItemExpression;
import org.josql.internal.Utilities;

public class JoSQLFreeChartXYDataset
extends Query
implements XYDataset {
    private List results = null;
    private Map series = new HashMap();
    private List listeners = new ArrayList();
    private DatasetGroup group = null;

    public void addChangeListener(DatasetChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(DatasetChangeListener l) {
        this.listeners.remove(l);
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup g) {
        this.group = g;
    }

    public int indexOf(Comparable c) {
        return (Integer)c;
    }

    public Comparable getSeriesKey(int series) {
        return Integer.valueOf(series);
    }

    public int getSeriesCount() {
        return this.series.size();
    }

    public void removeSeries(int series) {
        this.series.remove(series);
    }

    public void addSeries(int series, int xCol, int yCol) throws IllegalArgumentException, IllegalStateException, QueryParseException {
        if (!this.parsed()) {
            throw new IllegalStateException("Cannot add a series until a query has been specified and parsed.");
        }
        if (xCol < 1) {
            throw new IllegalArgumentException("X column index must be a minimum of 1.");
        }
        if (yCol < 1) {
            throw new IllegalArgumentException("Y column index must be a minimum of 1.");
        }
        List cols = this.getColumns();
        if (xCol > cols.size()) {
            throw new IllegalArgumentException("X column index must be a minimum of " + cols.size() + ".");
        }
        if (yCol > cols.size()) {
            throw new IllegalArgumentException("Y column index must be a minimum of " + cols.size() + ".");
        }
        SelectItemExpression xexp = (SelectItemExpression)cols.get(xCol - 1);
        Class xc = xexp.getExpectedReturnType(this);
        if (!Utilities.isNumber(xc)) {
            throw new IllegalArgumentException("X column: " + xexp + " will evaluate to an instance of type: " + xc.getName() + ", but only columns that return numbers are allowed.");
        }
        SelectItemExpression yexp = (SelectItemExpression)cols.get(yCol - 1);
        Class yc = yexp.getExpectedReturnType(this);
        if (!Utilities.isNumber(yc)) {
            throw new IllegalArgumentException("Y column: " + yexp + " will evaluate to an instance of type: " + yc.getName() + ", but only columns that return numbers are allowed.");
        }
        this.series.put(series, new Series(xCol, yCol));
    }

    public QueryResults executeQuery(List l) throws QueryExecutionException {
        if (this.isWantObjects()) {
            throw new QueryExecutionException("Only SQL statements that return columns (not the objects passed in) can be used.");
        }
        QueryResults qr = super.execute(l);
        this.results = qr.getResults();
        DatasetChangeEvent dce = new DatasetChangeEvent((Object)this, (Dataset)this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            DatasetChangeListener d = (DatasetChangeListener)this.listeners.get(i);
            d.datasetChanged(dce);
        }
        return qr;
    }

    public List getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results = null;
    }

    public int getItemCount(int series) {
        if (this.results == null) {
            return 0;
        }
        return this.results.size();
    }

    public double getXValue(int series, int item) {
        return (Double)this.getX(series, item);
    }

    public double getYValue(int series, int item) {
        return (Double)this.getY(series, item);
    }

    public Number getX(int series, int item) {
        if (this.results == null) {
            return new Double(0.0);
        }
        List l = (List)this.results.get(item);
        Series s = (Series)this.series.get(series);
        if (s == null) {
            return new Double(0.0);
        }
        Number n = (Number)l.get(s.xCol - 1);
        if (n instanceof Double) {
            return n;
        }
        return new Double(n.doubleValue());
    }

    public Number getY(int series, int item) {
        if (this.results == null) {
            return new Double(0.0);
        }
        List l = (List)this.results.get(item);
        Series s = (Series)this.series.get(series);
        if (s == null) {
            return new Double(0.0);
        }
        Number n = (Number)l.get(s.yCol - 1);
        if (n instanceof Double) {
            return n;
        }
        return new Double(n.doubleValue());
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    private class Series {
        public int xCol = 0;
        public int yCol = 0;

        public Series(int x, int y) {
            this.xCol = x;
            this.yCol = y;
        }
    }
}

