/*
 * Decompiled with CFR 0.152.
 */
package org.josql.contrib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jfree.data.DomainOrder;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;
import org.josql.expressions.SelectItemExpression;
import org.josql.internal.Utilities;

public class JoSQLFreeChartCategoryDataset
extends Query
implements CategoryDataset {
    private QueryResults results = null;
    private int xCol = 0;
    private List yCols = null;
    private List listeners = new ArrayList();
    private DatasetGroup group = null;

    public void addChangeListener(DatasetChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(DatasetChangeListener l) {
        this.listeners.remove(l);
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public QueryResults getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results = null;
    }

    public void setGroup(DatasetGroup g) {
        this.group = g;
    }

    public void define(int xCol, Object[] yCols) throws IllegalArgumentException, IllegalStateException, QueryParseException {
        this.define(xCol, Arrays.asList(yCols));
    }

    public void define(int xCol, int[] yCols) throws IllegalArgumentException, IllegalStateException, QueryParseException {
        ArrayList<Integer> l = new ArrayList<Integer>(yCols.length);
        for (int i = 0; i < yCols.length; ++i) {
            l.add(yCols[i]);
        }
        this.define(xCol, l);
    }

    public void define(int xCol, List yCols) throws IllegalArgumentException, IllegalStateException, QueryParseException {
        if (!this.parsed()) {
            throw new IllegalStateException("Cannot add a series until a query has been specified and parsed.");
        }
        if (xCol < 1) {
            throw new IllegalArgumentException("X column index must be a minimum of 1.");
        }
        for (int i = 0; i < yCols.size(); ++i) {
            Object o = yCols.get(i);
            if (o instanceof String) {
                try {
                    yCols.set(i, Integer.valueOf((String)o));
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to convert y column indicator: " + o + " to an integer.");
                }
            }
            if (o instanceof Number) {
                yCols.set(i, ((Number)o).intValue());
                continue;
            }
            if (o instanceof Integer) continue;
            throw new IllegalArgumentException("Expected y column indicator: " + o + " to be either a number or a string representing a number.");
        }
        List cols = this.getColumns();
        for (int i = 0; i < yCols.size(); ++i) {
            Integer in = (Integer)yCols.get(i);
            if (in < 1) {
                throw new IllegalArgumentException("Y column index must be a minimum of 1.");
            }
            if (in > cols.size()) {
                throw new IllegalArgumentException("Y column index must be a maximum of " + cols.size() + ".");
            }
            SelectItemExpression yexp = (SelectItemExpression)cols.get(in - 1);
            if (yexp.getAlias() == null) {
                throw new IllegalArgumentException("Y column: " + yexp + " must have an alias.");
            }
            Class yc = yexp.getExpectedReturnType(this);
            if (Utilities.isNumber(yc)) continue;
            throw new IllegalArgumentException("Y column: " + yexp + " will evaluate to an instance of type: " + yc.getName() + ", but only columns that return numbers are allowed.");
        }
        if (xCol > cols.size()) {
            throw new IllegalArgumentException("X column index must be a maximum of " + cols.size() + ".");
        }
        SelectItemExpression xexp = (SelectItemExpression)cols.get(xCol - 1);
        Class xc = xexp.getExpectedReturnType(this);
        if (!Comparable.class.isAssignableFrom(xc = Utilities.getObjectClass(xc))) {
            throw new IllegalArgumentException("X column: " + xexp + " will evaluate to an instance of type: " + xc.getName() + ", but only columns that implement: " + Comparable.class.getName() + " can be used.");
        }
        this.yCols = yCols;
    }

    public QueryResults executeQuery(List l) throws QueryExecutionException {
        if (this.isWantObjects()) {
            throw new QueryExecutionException("Only SQL statements that return columns (not the objects passed in) can be used.");
        }
        this.results = super.execute(l);
        DatasetChangeEvent dce = new DatasetChangeEvent((Object)this, (Dataset)this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            DatasetChangeListener d = (DatasetChangeListener)this.listeners.get(i);
            d.datasetChanged(dce);
        }
        return this.results;
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    public int getRowCount() {
        return this.results.getResults().size();
    }

    public int getColumnCount() {
        return this.yCols.size();
    }

    public Number getValue(int row, int col) {
        List l = (List)this.results.getResults().get(row);
        return (Number)l.get(col);
    }

    public List getRowKeys() {
        ArrayList ks = new ArrayList();
        for (int i = 0; i < this.results.getResults().size(); ++i) {
            List l = (List)this.results.getResults().get(i);
            ks.add(l.get(this.xCol));
        }
        return ks;
    }

    public Number getValue(Comparable row, Comparable col) {
        int rk = this.getRowIndex(row);
        int ck = this.getColumnIndex(col);
        List l = (List)this.results.getResults().get(rk);
        return (Number)l.get(ck);
    }

    public Comparable getColumnKey(int c) {
        return (Comparable)this.getColumnKeys().get(c);
    }

    public List getColumnKeys() {
        ArrayList<String> ks = new ArrayList<String>();
        for (int i = 0; i < this.yCols.size(); ++i) {
            Integer in = (Integer)this.yCols.get(i);
            SelectItemExpression sei = (SelectItemExpression)this.getColumns().get(in - 1);
            ks.add(sei.getAlias());
        }
        return ks;
    }

    public int getColumnIndex(Comparable c) {
        List ck = this.getColumnKeys();
        for (int i = 0; i < ck.size(); ++i) {
            if (((Comparable)ck.get(i)).compareTo(c) != 0) continue;
            return i;
        }
        return -1;
    }

    public int getRowIndex(Comparable c) {
        List rk = this.getRowKeys();
        for (int i = 0; i < rk.size(); ++i) {
            if (((Comparable)rk.get(i)).compareTo(c) != 0) continue;
            return i;
        }
        return -1;
    }

    public Comparable getRowKey(int k) {
        return (Comparable)this.getRowKeys().get(k);
    }
}

