/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import com.gentlyweb.utils.ChainException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File oldFile, File newFile, int bufSize) throws IOException {
        BufferedInputStream bin = null;
        BufferedOutputStream bout = null;
        try {
            bin = new BufferedInputStream(new FileInputStream(oldFile));
            bout = new BufferedOutputStream(new FileOutputStream(newFile));
            IOUtils.streamTo(bin, bout, bufSize);
        }
        finally {
            if (bin != null) {
                bin.close();
            }
            if (bout != null) {
                bout.flush();
                bout.close();
            }
        }
    }

    public static void gzipFile(File file, File newFile) throws ChainException {
        try {
            BufferedInputStream oldFileRead = new BufferedInputStream(new FileInputStream(file));
            GZIPOutputStream gzout = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
            try {
                byte[] buf = new byte[4096];
                IOUtils.streamTo(oldFileRead, gzout, 4096);
            }
            catch (IOException e) {
                throw new ChainException("Unable to gzip file: " + file.getPath() + " to: " + newFile.getPath(), e);
            }
            finally {
                if (oldFileRead != null) {
                    oldFileRead.close();
                }
                if (gzout != null) {
                    gzout.flush();
                    gzout.close();
                }
            }
        }
        catch (IOException e) {
            throw new ChainException("Unable to gzip file: " + file.getPath() + " to: " + newFile.getPath(), e);
        }
    }

    public static String getFileLengthAsFormattedKilobytes(long length) {
        long kilos = length / 1024L;
        long tenths = (length - kilos * 1024L) / 100L;
        return kilos + "." + tenths;
    }

    public static String getFormattedFileLength(long length) {
        long meg = 0x100000L;
        String val = "B";
        String num = "";
        if (length >= meg) {
            val = "MB";
        }
        if (length >= 1024L && length <= meg) {
            val = "KB";
        }
        if (length >= meg) {
            length /= 1024L;
        }
        if (length >= 1024L) {
            long m = length / 1024L;
            long n = (length - m * 1024L) / 100L;
            while (String.valueOf(n).length() > 2) {
                n /= 100L;
            }
            return m + "." + n + " " + val;
        }
        return length + " " + val;
    }

    public static void streamTo(InputStream in, OutputStream out, int bufSize) throws IOException {
        byte[] buf = new byte[bufSize];
        int bRead = -1;
        while ((bRead = in.read(buf)) != -1) {
            out.write(buf, 0, bRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesToFile(File file, byte[] bytes, int bufSize) throws IOException {
        if (bufSize <= 0) {
            bufSize = bytes.length;
        }
        BufferedInputStream bin = null;
        BufferedOutputStream bout = null;
        try {
            bin = new BufferedInputStream(new ByteArrayInputStream(bytes));
            bout = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.streamTo(bin, bout, bufSize);
        }
        finally {
            if (bin != null) {
                bin.close();
            }
            if (bout != null) {
                bout.flush();
                bout.close();
            }
        }
    }

    public static void writeBytesToFile(File file, byte[] bytes) throws IOException {
        IOUtils.writeBytesToFile(file, bytes, bytes.length);
    }

    public static void writeStringToFile(File file, String str, boolean compress) throws IOException {
        FilterOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        if (compress) {
            out = new GZIPOutputStream(out);
        }
        PrintWriter pout = new PrintWriter(out);
        pout.print(str);
        pout.flush();
        pout.close();
    }

    public static String getFile(File file) throws IOException {
        return new String(IOUtils.getFileAsArray(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileAsArray(File file) throws IOException {
        if (file == null) {
            throw new IOException("No file specified!");
        }
        if (!file.exists()) {
            throw new IOException("File: " + file + " does not exist.");
        }
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File: " + file.getPath() + " is greater than maximum value: " + Integer.MAX_VALUE);
        }
        byte[] chars = new byte[(int)length];
        try (BufferedInputStream bin = null;){
            bin = new BufferedInputStream(new FileInputStream(file));
            bin.read(chars, 0, (int)length);
        }
        return chars;
    }

    public static boolean getYNFromUser(String question) throws IOException {
        System.out.print(question);
        System.out.println(" [y|n, default y]");
        BufferedReader bread = new BufferedReader(new InputStreamReader(System.in));
        String line = bread.readLine();
        line = line.trim();
        line = line.toLowerCase();
        boolean val = false;
        if (line.equals("") || line.equals("y") || line.equals("yes")) {
            val = true;
        }
        if (!val) {
            System.out.println("Taking answer as n");
        }
        System.out.println();
        return val;
    }
}

