/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import com.gentlyweb.utils.Accessor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GeneralCollector {
    public static final String KEYS = "KEYS";
    public static final String VALUES = "VALUES";
    private Class clazz = null;
    private String field = null;
    private List accessorChain = null;

    public GeneralCollector(Class c) {
        this.clazz = c;
    }

    public GeneralCollector(Class c, String field) {
        this(c);
        this.setField(field);
    }

    public void collect(Map objects, String type, List retData) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Map.Entry obj : objects.entrySet()) {
            Object key = obj.getKey();
            Object value = obj.getValue();
            if (type.equals(KEYS)) {
                if (!key.getClass().isAssignableFrom(this.clazz)) {
                    throw new IllegalArgumentException("Expected key object to be of type: " + this.clazz.getName() + ", got: " + key.getClass().getName());
                }
                retData.add(Accessor.getValueFromAccessorChain(key, this.accessorChain));
                continue;
            }
            if (!value.getClass().isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException("Expected value object to be of type: " + this.clazz.getName() + ", got: " + value.getClass().getName());
            }
            retData.add(Accessor.getValueFromAccessorChain(value, this.accessorChain));
        }
    }

    public void collect(Map objects, String type, Collection retData) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Map.Entry obj : objects.entrySet()) {
            Object key = obj.getKey();
            Object value = obj.getValue();
            if (type.equals(KEYS)) {
                if (!key.getClass().isAssignableFrom(this.clazz)) {
                    throw new IllegalArgumentException("Expected key object to be of type: " + this.clazz.getName() + ", got: " + key.getClass().getName());
                }
                retData.add(Accessor.getValueFromAccessorChain(key, this.accessorChain));
                continue;
            }
            if (!value.getClass().isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException("Expected value object to be of type: " + this.clazz.getName() + ", got: " + value.getClass().getName());
            }
            retData.add(Accessor.getValueFromAccessorChain(value, this.accessorChain));
        }
    }

    public void collect(Map objects, String type, Map retData) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Map.Entry obj : objects.entrySet()) {
            Object key = obj.getKey();
            Object value = obj.getValue();
            if (type.equals(KEYS)) {
                if (!key.getClass().isAssignableFrom(this.clazz)) {
                    throw new IllegalArgumentException("Expected key object to be of type: " + this.clazz.getName() + ", got: " + key.getClass().getName());
                }
                retData.put(Accessor.getValueFromAccessorChain(key, this.accessorChain), value);
                continue;
            }
            if (!value.getClass().isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException("Expected value object to be of type: " + this.clazz.getName() + ", got: " + value.getClass().getName());
            }
            retData.put(key, Accessor.getValueFromAccessorChain(value, this.accessorChain));
        }
    }

    public void collect(Collection objects, Collection retData) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Object o : objects) {
            if (!o.getClass().isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException("Expected object to be of type: " + this.clazz.getName() + ", got: " + o.getClass().getName());
            }
            retData.add(Accessor.getValueFromAccessorChain(o, this.accessorChain));
        }
    }

    public void collect(Collection objects, List retData) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Object o : objects) {
            if (!o.getClass().isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException("Expected object to be of type: " + this.clazz.getName() + ", got: " + o.getClass().getName());
            }
            retData.add(Accessor.getValueFromAccessorChain(o, this.accessorChain));
        }
    }

    public void collect(List objects, List retData) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            if (!o.getClass().isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException("Expected object at index: " + i + " to be of type: " + this.clazz.getName() + ", got: " + o.getClass().getName());
            }
            retData.add(Accessor.getValueFromAccessorChain(o, this.accessorChain));
        }
    }

    public void collect(List objects, Collection retData) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < objects.size(); ++i) {
            Object o = objects.get(i);
            if (!o.getClass().isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException("Expected object at index: " + i + " to be of type: " + this.clazz.getName() + ", got: " + o.getClass().getName());
            }
            retData.add(Accessor.getValueFromAccessorChain(o, this.accessorChain));
        }
    }

    public void setField(String field) throws IllegalArgumentException {
        this.field = field;
        this.accessorChain = Accessor.getAccessorChain(field, this.clazz);
    }

    public String getField() {
        return this.field;
    }
}

