/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.geojson.query;

import java.io.Serializable;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$;
import org.locationtech.geomesa.geojson.query.GeoJsonQuery;
import org.locationtech.geomesa.geojson.query.GeoJsonQuery$Include$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.locationtech.jts.io.geojson.GeoJsonWriter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class GeoJsonQuery$ {
    public static GeoJsonQuery$ MODULE$;
    private final String defaultGeom;
    private final GeoJsonReader geometryReader;
    private final GeoJsonWriter geometryWriter;

    static {
        new GeoJsonQuery$();
    }

    public String defaultGeom() {
        return this.defaultGeom;
    }

    private GeoJsonReader geometryReader() {
        return this.geometryReader;
    }

    private GeoJsonWriter geometryWriter() {
        return this.geometryWriter;
    }

    public GeoJsonQuery apply(JsonAST.JValue jsonValue) {
        JsonAST.JValue jValue = jsonValue;
        if (!(jValue instanceof JsonAST.JObject)) {
            throw new IllegalArgumentException("Invalid input - expected JSON object");
        }
        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
        GeoJsonQuery geoJsonQuery = this.evaluate(jObject);
        return geoJsonQuery;
    }

    public GeoJsonQuery apply(String query) {
        GeoJsonQuery geoJsonQuery;
        if (query == null || query.isEmpty()) {
            geoJsonQuery = GeoJsonQuery$Include$.MODULE$;
        } else {
            try {
                geoJsonQuery = this.apply(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(query), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringBuilder(22).append("Invalid query string:\n").append(query).toString(), e);
                }
                throw throwable;
            }
        }
        return geoJsonQuery;
    }

    public String checkJsonPaths(String str) {
        return str.startsWith("$.") ? JsonPathParser$.MODULE$.print(JsonPathParser$.MODULE$.parse(str, JsonPathParser$.MODULE$.parse$default$2()), JsonPathParser$.MODULE$.print$default$2()) : str;
    }

    private GeoJsonQuery evaluate(JsonAST.JObject json) {
        List predicates;
        return json.obj().isEmpty() ? GeoJsonQuery$Include$.MODULE$ : ((predicates = (List)json.obj().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String prop = (String)tuple2._1();
                JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
                if (v instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)v;
                    return MODULE$.evaluatePredicate(MODULE$.checkJsonPaths(prop), jObject);
                }
            }
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
                if ("$or".equals(string) && v instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)v;
                    List ors = (List)jArray.arr().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        JsonAST.JValue jValue = x0$2;
                        if (!(jValue instanceof JsonAST.JObject)) {
                            throw new IllegalArgumentException(new StringBuilder(21).append("Expected Object, got ").append(jValue).toString());
                        }
                        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                        GeoJsonQuery geoJsonQuery = MODULE$.evaluate(jObject);
                        return geoJsonQuery;
                    }, List$.MODULE$.canBuildFrom());
                    return new GeoJsonQuery.Or((Seq<GeoJsonQuery>)ors);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String prop = (String)tuple2._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
            if (v == null) throw new MatchError((Object)tuple2);
            JsonAST.JValue jValue = v;
            return new GeoJsonQuery.Equals(MODULE$.checkJsonPaths(prop), jValue.values());
        }, List$.MODULE$.canBuildFrom())).length() > 1 ? new GeoJsonQuery.And((Seq<GeoJsonQuery>)predicates) : (GeoJsonQuery)predicates.head());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private GeoJsonQuery evaluatePredicate(String prop, JsonAST.JObject json) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2 tuple23;
        Tuple2 tuple24;
        Tuple2 tuple25;
        Tuple2 tuple26;
        Tuple2 tuple27;
        Tuple2 tuple28;
        Tuple2 tuple29;
        void var3_31;
        boolean bl = false;
        Some some = null;
        Option option = json.obj().headOption();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Tuple2 tuple210 = (Tuple2)some.value();
            if (tuple210 != null) {
                String string = (String)tuple210._1();
                JsonAST.JValue v = (JsonAST.JValue)tuple210._2();
                if ("$bbox".equals(string) && v instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)v;
                    List list = jArray.values();
                    Some some2 = List$.MODULE$.unapplySeq((Seq)list);
                    if (some2.isEmpty()) throw new MatchError((Object)list);
                    if (some2.get() == null) throw new MatchError((Object)list);
                    if (((LinearSeqOptimized)some2.get()).lengthCompare(4) != 0) throw new MatchError((Object)list);
                    Number xmin = (Number)((LinearSeqOptimized)some2.get()).apply(0);
                    Number ymin = (Number)((LinearSeqOptimized)some2.get()).apply(1);
                    Number xmax = (Number)((LinearSeqOptimized)some2.get()).apply(2);
                    Number ymax = (Number)((LinearSeqOptimized)some2.get()).apply(3);
                    Tuple4 tuple4 = new Tuple4((Object)xmin, (Object)ymin, (Object)xmax, (Object)ymax);
                    Tuple4 tuple42 = tuple4;
                    Number xmin2 = (Number)tuple42._1();
                    Number ymin2 = (Number)tuple42._2();
                    Number xmax2 = (Number)tuple42._3();
                    Number ymax2 = (Number)tuple42._4();
                    GeoJsonQuery.Bbox bbox = new GeoJsonQuery.Bbox(prop, xmin2.doubleValue(), ymin2.doubleValue(), xmax2.doubleValue(), ymax2.doubleValue());
                    return var3_31;
                }
            }
        }
        if (bl && (tuple29 = (Tuple2)some.value()) != null) {
            String string = (String)tuple29._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple29._2();
            if ("$intersects".equals(string) && v instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)v;
                GeoJsonQuery.Intersects intersects = new GeoJsonQuery.Intersects(prop, this.evaluateGeometry(jObject));
                return var3_31;
            }
        }
        if (bl && (tuple28 = (Tuple2)some.value()) != null) {
            String string = (String)tuple28._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple28._2();
            if ("$within".equals(string) && v instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)v;
                GeoJsonQuery.Within within = new GeoJsonQuery.Within(prop, this.evaluateGeometry(jObject));
                return var3_31;
            }
        }
        if (bl && (tuple27 = (Tuple2)some.value()) != null) {
            String string = (String)tuple27._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple27._2();
            if ("$dwithin".equals(string) && v instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)v;
                Tuple2<Object, String> tuple211 = this.evaluateDwithin(jObject);
                if (tuple211 == null) throw new MatchError(tuple211);
                double dist = tuple211._1$mcD$sp();
                String unit = (String)tuple211._2();
                Tuple2 tuple212 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)dist), (Object)unit);
                Tuple2 tuple213 = tuple212;
                double dist2 = tuple213._1$mcD$sp();
                String unit2 = (String)tuple213._2();
                GeoJsonQuery.Dwithin dwithin = new GeoJsonQuery.Dwithin(prop, this.evaluateGeometry(jObject), dist2, unit2);
                return var3_31;
            }
        }
        if (bl && (tuple26 = (Tuple2)some.value()) != null) {
            String string = (String)tuple26._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple26._2();
            if ("$contains".equals(string) && v instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)v;
                GeoJsonQuery.Contains contains = new GeoJsonQuery.Contains(prop, this.evaluateGeometry(jObject));
                return var3_31;
            }
        }
        if (bl && (tuple25 = (Tuple2)some.value()) != null) {
            String string = (String)tuple25._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple25._2();
            if ("$lt".equals(string)) {
                GeoJsonQuery.LessThan lessThan = new GeoJsonQuery.LessThan(prop, v.values(), false);
                return var3_31;
            }
        }
        if (bl && (tuple24 = (Tuple2)some.value()) != null) {
            String string = (String)tuple24._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple24._2();
            if ("$lte".equals(string)) {
                GeoJsonQuery.LessThan lessThan = new GeoJsonQuery.LessThan(prop, v.values(), true);
                return var3_31;
            }
        }
        if (bl && (tuple23 = (Tuple2)some.value()) != null) {
            String string = (String)tuple23._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple23._2();
            if ("$gt".equals(string)) {
                GeoJsonQuery.GreaterThan greaterThan = new GeoJsonQuery.GreaterThan(prop, v.values(), false);
                return var3_31;
            }
        }
        if (bl && (tuple22 = (Tuple2)some.value()) != null) {
            String string = (String)tuple22._1();
            JsonAST.JValue v = (JsonAST.JValue)tuple22._2();
            if ("$gte".equals(string)) {
                GeoJsonQuery.GreaterThan greaterThan = new GeoJsonQuery.GreaterThan(prop, v.values(), true);
                return var3_31;
            }
        }
        if (bl && (tuple2 = (Tuple2)some.value()) != null) {
            String p = (String)tuple2._1();
            throw new IllegalArgumentException(new StringBuilder(20).append("Invalid predicate '").append(p).append("'").toString());
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        throw new IllegalArgumentException("Invalid json structure");
    }

    private Geometry evaluateGeometry(JsonAST.JObject json) {
        JsonAST.JValue geom;
        JsonAST.JValue x$1 = geom = (JsonAST.JValue)json.obj().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GeoJsonQuery$.$anonfun$evaluateGeometry$1(x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> (JsonAST.JValue)x$4._2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(24).append("Expected $geometry, got ").append(((TraversableOnce)json.obj().map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1(), List$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        });
        Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
        return this.geometryReader().read(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2)));
    }

    private Tuple2<Object, String> evaluateDwithin(JsonAST.JObject json) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        double distance = BoxesRunTime.unboxToDouble((Object)package$.MODULE$.jvalue2extractable((JsonAST.JValue)json.obj().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GeoJsonQuery$.$anonfun$evaluateDwithin$1(x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> (JsonAST.JValue)x$7._2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(20).append("Expected $dist, got ").append(((TraversableOnce)json.obj().map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8._1(), List$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        })).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Double()));
        String unit = (String)package$.MODULE$.jvalue2extractable((JsonAST.JValue)json.obj().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)GeoJsonQuery$.$anonfun$evaluateDwithin$5(x$9))).map((Function1 & Serializable & scala.Serializable)x$10 -> (JsonAST.JValue)x$10._2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(20).append("Expected $unit, got ").append(((TraversableOnce)json.obj().map((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11._1(), List$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        })).extract((Formats)formats, ManifestFactory$.MODULE$.classType(String.class));
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)distance), (Object)unit);
    }

    public String org$locationtech$geomesa$geojson$query$GeoJsonQuery$$printJson(Geometry geometry) {
        return new StringBuilder(14).append("{\"$geometry\":").append(this.geometryWriter().write(geometry)).append("}").toString();
    }

    public String org$locationtech$geomesa$geojson$query$GeoJsonQuery$$printJson(Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "null";
        } else if (object instanceof String) {
            String string2 = (String)object;
            string = new StringBuilder(2).append("\"").append(string2).append("\"").toString();
        } else {
            string = object.toString();
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$evaluateGeometry$1(Tuple2 x$3) {
        Object object = x$3._1();
        String string = "$geometry";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$evaluateDwithin$1(Tuple2 x$6) {
        Object object = x$6._1();
        String string = "$dist";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$evaluateDwithin$5(Tuple2 x$9) {
        Object object = x$9._1();
        String string = "$unit";
        return !(object != null ? !object.equals(string) : string != null);
    }

    /*
     * WARNING - void declaration
     */
    private GeoJsonQuery$() {
        void var1_1;
        MODULE$ = this;
        this.defaultGeom = "geom";
        this.geometryReader = new GeoJsonReader();
        GeoJsonWriter writer = new GeoJsonWriter();
        writer.setEncodeCRS(false);
        this.geometryWriter = var1_1;
    }
}

