/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.geojson;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.util.function.Function;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser;
import org.locationtech.geomesa.features.kryo.json.JsonPathParser$;
import org.locationtech.geomesa.utils.cache.CacheKeyGenerator$;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class GeoJsonGtIndex$ {
    public static GeoJsonGtIndex$ MODULE$;
    private final String IdPathKey;
    private final String DtgPathKey;
    private final GeoJsonReader geometryReader;
    private final Cache<String, Tuple3<Function1<JsonAST.JObject, Geometry>, Function1<JsonAST.JObject, Option<String>>, Function1<JsonAST.JObject, Option<Object>>>> extractorCache;

    static {
        new GeoJsonGtIndex$();
    }

    public String IdPathKey() {
        return this.IdPathKey;
    }

    public String DtgPathKey() {
        return this.DtgPathKey;
    }

    private GeoJsonReader geometryReader() {
        return this.geometryReader;
    }

    private Cache<String, Tuple3<Function1<JsonAST.JObject, Geometry>, Function1<JsonAST.JObject, Option<String>>, Function1<JsonAST.JObject, Option<Object>>>> extractorCache() {
        return this.extractorCache;
    }

    public String org$locationtech$geomesa$geojson$GeoJsonGtIndex$$spec(Option<String> idPath, Option<String> dtgPath, boolean points) {
        String geomType = points ? "Point" : "Geometry";
        StringBuilder spec = new StringBuilder(new java.lang.StringBuilder(38).append("json:String:json=true,*geom:").append(geomType).append(":srid=4326").toString());
        Object object = dtgPath.isDefined() ? spec.append(",dtg:Date") : BoxedUnit.UNIT;
        Seq mixedGeoms = points ? (Seq)Nil$.MODULE$ : (Seq)new .colon.colon((Object)new java.lang.StringBuilder(7).append(SimpleFeatureTypes.Configs$.MODULE$.MixedGeometries()).append("='true'").toString(), (List)Nil$.MODULE$);
        Option id = idPath.map((Function1 & Serializable & scala.Serializable)p -> new java.lang.StringBuilder(3).append(MODULE$.IdPathKey()).append("='").append((String)p).append("'").toString());
        Option dtg = dtgPath.map((Function1 & Serializable & scala.Serializable)p -> new java.lang.StringBuilder(3).append(MODULE$.DtgPathKey()).append("='").append((String)p).append("'").toString());
        String userData = ((TraversableOnce)((TraversableLike)mixedGeoms.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(id), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(dtg), Seq$.MODULE$.canBuildFrom())).mkString(";", ",", "");
        spec.append(userData);
        return spec.toString();
    }

    public Tuple3<Function1<JsonAST.JObject, Geometry>, Function1<JsonAST.JObject, Option<String>>, Function1<JsonAST.JObject, Option<Object>>> org$locationtech$geomesa$geojson$GeoJsonGtIndex$$jsonExtractors(SimpleFeatureType schema) {
        Function<String, Tuple3<Function1<JsonAST.JObject, Geometry>, Function1<JsonAST.JObject, Option<String>>, Function1<JsonAST.JObject, Option<Object>>>> loader = new Function<String, Tuple3<Function1<JsonAST.JObject, Geometry>, Function1<JsonAST.JObject, Option<String>>, Function1<JsonAST.JObject, Option<Object>>>>(schema){
            private final SimpleFeatureType schema$1;

            public <V> Function<V, Tuple3<Function1<JsonAST.JObject, Geometry>, Function1<JsonAST.JObject, Option<String>>, Function1<JsonAST.JObject, Option<Object>>>> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Tuple3<Function1<JsonAST.JObject, Geometry>, Function1<JsonAST.JObject, Option<String>>, Function1<JsonAST.JObject, Option<Object>>>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Tuple3<Function1<JsonAST.JObject, Geometry>, Function1<JsonAST.JObject, Option<String>>, Function1<JsonAST.JObject, Option<Object>>> apply(String ignored) {
                return GeoJsonGtIndex$.MODULE$.org$locationtech$geomesa$geojson$GeoJsonGtIndex$$load$1(this.schema$1);
            }
            {
                this.schema$1 = schema$1;
            }
        };
        return (Tuple3)this.extractorCache().get((Object)CacheKeyGenerator$.MODULE$.cacheKey(schema), (Function)loader);
    }

    public Option<Seq<JsonPathParser.PathElement>> org$locationtech$geomesa$geojson$GeoJsonGtIndex$$getIdPath(SimpleFeatureType schema) {
        return Option$.MODULE$.apply((Object)((String)schema.getUserData().get(this.IdPathKey()))).map((Function1 & Serializable & scala.Serializable)x$18 -> JsonPathParser$.MODULE$.parse(x$18, JsonPathParser$.MODULE$.parse$default$2()));
    }

    public Option<Seq<JsonPathParser.PathElement>> org$locationtech$geomesa$geojson$GeoJsonGtIndex$$getDtgPath(SimpleFeatureType schema) {
        return Option$.MODULE$.apply((Object)((String)schema.getUserData().get(this.DtgPathKey()))).map((Function1 & Serializable & scala.Serializable)x$19 -> JsonPathParser$.MODULE$.parse(x$19, JsonPathParser$.MODULE$.parse$default$2()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<JsonAST.JObject> org$locationtech$geomesa$geojson$GeoJsonGtIndex$$parseFeatures(String json) {
        JsonAST.JObject jObject;
        JsonAST.JValue jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        if (!(jValue instanceof JsonAST.JObject)) throw new IllegalArgumentException("Invalid input - expected JSON object");
        JsonAST.JObject jObject2 = jObject = (JsonAST.JObject)jValue;
        JsonAST.JObject parsed = jObject2;
        boolean bl = false;
        Some some = null;
        Option option = this.getByKey(parsed, "type").map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.values());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Object object = some.value();
            if ("Feature".equals(object)) {
                return (Seq)new .colon.colon((Object)parsed, (List)Nil$.MODULE$);
            }
        }
        if (!bl) throw new IllegalArgumentException(new java.lang.StringBuilder(61).append("Invalid input type '").append(option.orNull(Predef$.MODULE$.$conforms())).append("' - expected [Feature, FeatureCollection]").toString());
        Object object = some.value();
        if (!"FeatureCollection".equals(object)) throw new IllegalArgumentException(new java.lang.StringBuilder(61).append("Invalid input type '").append(option.orNull(Predef$.MODULE$.$conforms())).append("' - expected [Feature, FeatureCollection]").toString());
        Option<JsonAST.JValue> features = this.getByKey(parsed, "features");
        return (Seq)features.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends JsonAST.JValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)A1;
                    object = jArray.arr();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonAST.JValue x1) {
                JsonAST.JValue jValue = x1;
                boolean bl = jValue instanceof JsonAST.JArray;
                return bl;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
    }

    private Geometry getGeometry(JsonAST.JObject feature) {
        return (Geometry)this.getByKey(feature, "geometry").map((Function1 & Serializable & scala.Serializable)g -> {
            JsonAST.JValue x$1 = g;
            Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
            return MODULE$.geometryReader().read(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2)));
        }).orNull(Predef$.MODULE$.$conforms());
    }

    private Option<JsonAST.JValue> getByKey(JsonAST.JObject o, String key) {
        return ScalaImplicits.RichIterator$.MODULE$.headOption$extension(ScalaImplicits$.MODULE$.RichIterator(o.obj().toIterator().collect((PartialFunction)new scala.Serializable(key){
            public static final long serialVersionUID = 0L;
            private final String key$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String k = (String)A1._1();
                    JsonAST.JValue v = (JsonAST.JValue)A1._2();
                    String string = k;
                    String string2 = this.key$2;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = v;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                String k;
                Tuple2<String, JsonAST.JValue> tuple2 = x1;
                if (tuple2 == null) return false;
                String string = k = (String)tuple2._1();
                String string2 = this.key$2;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                this.key$2 = key$2;
            }
        })));
    }

    private Option<Object> evaluatePathValue(JsonAST.JObject json, Seq<JsonPathParser.PathElement> path) {
        return this.org$locationtech$geomesa$geojson$GeoJsonGtIndex$$evaluatePath(json, path).map((Function1 & Serializable & scala.Serializable)jval -> GeoJsonGtIndex$.renderValue$1(jval));
    }

    public Option<JsonAST.JValue> org$locationtech$geomesa$geojson$GeoJsonGtIndex$$evaluatePath(JsonAST.JObject json, Seq<JsonPathParser.PathElement> path) {
        ObjectRef selected = ObjectRef.create((Object)((Seq)new .colon.colon((Object)json, (List)Nil$.MODULE$)));
        path.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GeoJsonGtIndex$.$anonfun$evaluatePath$1(selected, x0$1);
            return BoxedUnit.UNIT;
        });
        return ((Seq)selected.elem).headOption();
    }

    public final Tuple3 org$locationtech$geomesa$geojson$GeoJsonGtIndex$$load$1(SimpleFeatureType schema$1) {
        Function1 & Serializable & scala.Serializable intersect;
        Function1 & Serializable & scala.Serializable intersect2;
        Function1 & Serializable & scala.Serializable getGeom = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(schema$1)) ? (Function1 & Serializable & scala.Serializable)feature -> {
            Point point;
            Geometry geometry = MODULE$.getGeometry((JsonAST.JObject)feature);
            if (geometry instanceof Point) {
                Point point2;
                point = point2 = (Point)geometry;
            } else if (geometry != null) {
                Geometry geometry2 = geometry;
                point = geometry2.getCentroid();
            } else if (geometry == null) {
                point = null;
            } else {
                throw new MatchError((Object)geometry);
            }
            return point;
        } : (Function1 & Serializable & scala.Serializable)feature -> MODULE$.getGeometry((JsonAST.JObject)feature);
        Option<Seq<JsonPathParser.PathElement>> option = this.org$locationtech$geomesa$geojson$GeoJsonGtIndex$$getIdPath(schema$1);
        if (None$.MODULE$.equals(option)) {
            intersect2 = (Function1 & Serializable & scala.Serializable)x$15 -> None$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Seq path = (Seq)some.value();
            intersect2 = (Function1 & Serializable & scala.Serializable)feature -> MODULE$.evaluatePathValue((JsonAST.JObject)feature, (Seq<JsonPathParser.PathElement>)path).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.toString());
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable & scala.Serializable getId = intersect2;
        Option<Seq<JsonPathParser.PathElement>> option2 = this.org$locationtech$geomesa$geojson$GeoJsonGtIndex$$getDtgPath(schema$1);
        if (None$.MODULE$.equals(option2)) {
            intersect = (Function1 & Serializable & scala.Serializable)x$17 -> None$.MODULE$;
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            Seq path = (Seq)some.value();
            intersect = (Function1 & Serializable & scala.Serializable)feature -> MODULE$.evaluatePathValue((JsonAST.JObject)feature, (Seq<JsonPathParser.PathElement>)path);
        } else {
            throw new MatchError(option2);
        }
        Function1 & Serializable & scala.Serializable getDtg = intersect;
        return new Tuple3((Object)getGeom, (Object)getId, (Object)getDtg);
    }

    private static final Object renderValue$1(JsonAST.JValue jval2) {
        Object object;
        JsonAST.JValue jValue = jval2;
        if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject;
            JsonAST.JObject x$1 = jObject = (JsonAST.JObject)jValue;
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            object = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        } else if (jValue instanceof JsonAST.JArray) {
            JsonAST.JArray jArray = (JsonAST.JArray)jValue;
            object = jArray.arr().map((Function1 & Serializable & scala.Serializable)jval -> GeoJsonGtIndex$.renderValue$1(jval), List$.MODULE$.canBuildFrom());
        } else if (jValue != null) {
            JsonAST.JValue jValue2 = jValue;
            object = jValue2.values();
        } else {
            throw new MatchError((Object)jValue);
        }
        return object;
    }

    public static final /* synthetic */ Iterable $anonfun$evaluatePath$5(JsonAST.JArray x2$1, int i) {
        return x2$1.arr().length() > i ? Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x2$1.arr().apply(i))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$evaluatePath$1(ObjectRef selected$1, JsonPathParser.PathElement x0$1) {
        JsonPathParser.PathIndices pathIndices;
        Seq indices;
        JsonPathParser.PathElement pathElement = x0$1;
        if (pathElement instanceof JsonPathParser.PathAttribute) {
            JsonPathParser.PathAttribute pathAttribute = (JsonPathParser.PathAttribute)pathElement;
            String name = pathAttribute.name();
            selected$1.elem = (Seq)((Seq)selected$1.elem).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Seq seq;
                JsonAST.JValue jValue = x0$2;
                if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    seq = (Seq)jObject.obj().collect((PartialFunction)new scala.Serializable(name){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                String n = (String)A1._1();
                                JsonAST.JValue v = (JsonAST.JValue)A1._2();
                                String string = n;
                                String string2 = this.name$1;
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    object = v;
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                            String n;
                            Tuple2<String, JsonAST.JValue> tuple2 = x1;
                            if (tuple2 == null) return false;
                            String string = n = (String)tuple2._1();
                            String string2 = this.name$1;
                            if (string != null) {
                                if (!string.equals(string2)) return false;
                                return true;
                            }
                            if (string2 == null) return true;
                            return false;
                        }
                        {
                            this.name$1 = name$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                } else {
                    seq = (Seq)Nil$.MODULE$;
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pathElement instanceof JsonPathParser.PathIndex) {
            int index;
            JsonPathParser.PathIndex pathIndex = (JsonPathParser.PathIndex)pathElement;
            int n = index = pathIndex.index();
            selected$1.elem = (Seq)((Seq)selected$1.elem).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                JsonAST.JArray jArray;
                JsonAST.JValue jValue = x0$3;
                Seq seq = jValue instanceof JsonAST.JArray && (jArray = (JsonAST.JArray)jValue).arr().length() > n ? (Seq)new .colon.colon((Object)((JsonAST.JValue)jArray.arr().apply(n)), (List)Nil$.MODULE$) : (Seq)Nil$.MODULE$;
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pathElement instanceof JsonPathParser.PathIndices && (indices = (pathIndices = (JsonPathParser.PathIndices)pathElement).indices()) != null) {
            Seq seq = indices;
            selected$1.elem = (Seq)((Seq)selected$1.elem).flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Seq seq;
                JsonAST.JValue jValue = x0$4;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    seq = (Seq)seq.flatMap((Function1 & Serializable & scala.Serializable)i -> GeoJsonGtIndex$.$anonfun$evaluatePath$5(jArray, BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom());
                } else {
                    seq = (Seq)Nil$.MODULE$;
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonPathParser.PathAttributeWildCard$.MODULE$.equals(pathElement)) {
            selected$1.elem = (Seq)((Seq)selected$1.elem).flatMap((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Seq seq;
                JsonAST.JValue jValue = x0$5;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    seq = jArray.arr();
                } else {
                    seq = (Seq)Nil$.MODULE$;
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (JsonPathParser.PathIndexWildCard$.MODULE$.equals(pathElement)) {
            selected$1.elem = (Seq)((Seq)selected$1.elem).flatMap((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Seq seq;
                JsonAST.JValue jValue = x0$6;
                if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    seq = (Seq)jObject.obj().map((Function1 & Serializable & scala.Serializable)x$21 -> (JsonAST.JValue)x$21._2(), List$.MODULE$.canBuildFrom());
                } else {
                    seq = (Seq)Nil$.MODULE$;
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (pathElement instanceof JsonPathParser.PathFunction) {
                throw new NotImplementedError("Path functions not implemented");
            }
            if (JsonPathParser.PathDeepScan$.MODULE$.equals(pathElement)) {
                throw new NotImplementedError("Deep scan not implemented");
            }
            throw new MatchError((Object)pathElement);
        }
    }

    private GeoJsonGtIndex$() {
        MODULE$ = this;
        this.IdPathKey = new java.lang.StringBuilder(7).append(SimpleFeatureTypes.InternalConfigs$.MODULE$.GeomesaPrefix()).append("json.id").toString();
        this.DtgPathKey = new java.lang.StringBuilder(8).append(SimpleFeatureTypes.InternalConfigs$.MODULE$.GeomesaPrefix()).append("json.dtg").toString();
        this.geometryReader = new GeoJsonReader();
        this.extractorCache = Caffeine.newBuilder().build();
    }
}

