/*
 * Decompiled with CFR 0.152.
 */
package org.loader.autohideime;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;

public class AutoHideIMEFrameLayout
extends FrameLayout {
    public AutoHideIMEFrameLayout(Context context) {
        super(context);
    }

    public AutoHideIMEFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AutoHideIMEFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            Context context = this.getContext();
            if (context == null || !(context instanceof Activity)) {
                return super.dispatchTouchEvent(ev);
            }
            Activity activity = (Activity)context;
            View focusView = activity.getCurrentFocus();
            if (focusView != null && this.shouldHideInputMethod(focusView, ev)) {
                this.hideInputMethod(focusView);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private boolean shouldHideInputMethod(View focusView, MotionEvent event) {
        Rect rect = new Rect();
        focusView.getHitRect(rect);
        return !rect.contains((int)event.getX(), (int)event.getY());
    }

    private void hideInputMethod(View currentFocus) {
        if (currentFocus == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)currentFocus.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(currentFocus.getWindowToken(), 2);
    }
}

