/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.littleshoot.util.IoExceptionWithCause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XmlUtils.class);
    private static final XPathFactory s_xPathFactory = XPathFactory.newInstance();
    private static final XPath s_path = s_xPathFactory.newXPath();
    public static final NodeList EMPTY_NODE_LIST = new NodeList(){

        @Override
        public Node item(int index) {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }
    };

    public static void replaceNodeValue(Document doc, String xPath, String newValue) {
        Text textNode = doc.createTextNode(newValue);
        try {
            Node node = (Node)s_path.evaluate(xPath, doc, XPathConstants.NODE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found node: " + node.getNodeName());
            }
            if (node == null) {
                LOG.warn("Could not find xPath: " + xPath);
                return;
            }
            node.replaceChild(textNode, node.getFirstChild());
        }
        catch (XPathExpressionException e) {
            LOG.error("Bad XPath: " + xPath, (Throwable)e);
        }
    }

    public static void printDoc(Document doc) {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.transform(new DOMSource(doc), new StreamResult(System.out));
        }
        catch (TransformerConfigurationException e) {
            LOG.error("Could not configure transformer", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            LOG.error("Could not configure transformer factory", (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error("Error running transformation", (Throwable)e);
        }
    }

    public static String toString(Document doc) {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerConfigurationException e) {
            LOG.error("Could not configure transformer", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            LOG.error("Could not configure transformer factory", (Throwable)e);
        }
        catch (TransformerException e) {
            LOG.error("Error running transformation", (Throwable)e);
        }
        return "";
    }

    public static Document toDoc(String str) throws IOException, SAXException {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.error("Parser error?", (Throwable)e);
            throw new IoExceptionWithCause("Parser error??", e);
        }
        return db.parse(new InputSource(new StringReader(str)));
    }

    public static Document toDoc(InputStream is) throws IOException, SAXException {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.error("Parser error?", (Throwable)e);
            throw new IoExceptionWithCause("Parser error??", e);
        }
        return db.parse(is);
    }

    public static Document toDoc(InputStream is, String endStatementTag) throws IOException, SAXException {
        String line;
        LOG.info("Reading stream to XML document");
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            LOG.info("Read line: " + line);
            if (!line.trim().endsWith(endStatementTag)) continue;
            return XmlUtils.toDoc(sb.toString());
        }
        throw new IOException("Could not read doc?");
    }

    public static void printDoc(String xml) {
        try {
            Document doc = XmlUtils.toDoc(xml);
            XmlUtils.printDoc(doc);
        }
        catch (IOException e) {
            LOG.warn("Could not print", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.warn("Could not print", (Throwable)e);
        }
    }
}

