/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.littleshoot.util.Base64;
import org.littleshoot.util.Sha1Hasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String signAndEncode(String accessKey, String canonicalString) {
        Mac mac;
        if (StringUtils.isBlank((String)accessKey)) {
            LOG.warn("Empty key!!");
            throw new IllegalArgumentException("Empty key");
        }
        SecretKeySpec signingKey = new SecretKeySpec(accessKey.getBytes(), HMAC_SHA1_ALGORITHM);
        try {
            mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("No SHA-1", (Throwable)e);
            throw new RuntimeException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            LOG.error("Bad key", (Throwable)e);
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        String b64 = Base64.encodeBytes(mac.doFinal(canonicalString.getBytes()));
        return b64;
    }

    public static String hash(String str) {
        return Sha1Hasher.hash(str);
    }
}

