/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.littleshoot.util.ResourceTypeTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypeTranslatorImpl
implements ResourceTypeTranslator {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> m_types = new ConcurrentHashMap<String, String>();
    private final String[] DOCUMENTS = new String[]{"html", "htm", "xhtml", "mht", "mhtml", "xml", "txt", "ans", "asc", "diz", "eml", "pdf", "ps", "epsf", "dvi", "rtf", "wri", "doc", "mcw", "wps", "xls", "wk1", "dif", "csv", "ppt", "tsv", "hlp", "chm", "lit", "tex", "texi", "latex", "info", "man", "wp", "wpd", "wp5", "wk3", "wk4", "shw", "sdd", "sdw", "sdp", "sdc", "sxd", "sxw", "sxp", "sxc", "abw", "kwd", "js", "java", "cpp", "c", "py", "php", "ruby", "pps", "dll", "jhtml", "mmap", "dat", "url", "bash", "sh", "csh", "pl"};
    private final String[] OSX_APPLICATIONS = new String[]{"dmg", "pkg"};
    private final String[] LINUX_APPLICATIONS = new String[]{"mdb", "awk", "rpm", "deb", "z", "zoo", "tar", "taz", "shar", "hqx", "7z"};
    private final String[] WINDOWS_APPLICATIONS = new String[]{"exe", "cab", "msi", "msp", "arj", "ace", "nsi"};
    private final String[] AUDIO = new String[]{"mp3", "mpa", "mp1", "mpga", "mp2", "ra", "rm", "ram", "rmj", "wma", "wav", "m4a", "m4p", "lqt", "ogg", "med", "aif", "aiff", "aifc", "au", "snd", "s3m", "aud", "mid", "midi", "rmi", "mod", "kar", "ac3", "shn", "fla", "flac", "cda", "mka"};
    private final String[] VIDEO = new String[]{"mpg", "mpeg", "mpe", "mng", "mpv", "m1v", "vob", "mpv2", "mp2v", "m2p", "m2v", "m4v", "mpgv", "vcd", "mp4", "dv", "dvd", "div", "divx", "dvx", "smi", "smil", "rv", "rmm", "rmvb", "avi", "asf", "asx", "wmv", "qt", "mov", "fli", "flc", "flx", "flv", "wml", "vrml", "swf", "dcr", "jve", "nsv", "mkv", "ogm", "cdg", "srt", "sub", "idx", "msmedia", "wvx"};
    private final String[] IMAGE = new String[]{"gif", "png", "jpg", "jpeg", "jpe", "jif", "jiff", "jfif", "tif", "tiff", "iff", "lbm", "ilbm", "eps", "mac", "drw", "pct", "img", "bmp", "dib", "rle", "ico", "ani", "icl", "cur", "emf", "wmf", "pcx", "pcd", "tga", "pic", "fig", "psd", "wpg", "dcx", "cpt", "mic", "pbm", "pnm", "ppm", "xbm", "xpm", "xwd", "sgi", "fax", "rgb", "ras"};
    private final String[] GENERAL_APPLICATION = new String[]{"jar", "jnlp", "iso", "bin", "nrg", "cue"};
    private final String[] ARCHIVE = new String[]{"zip", "sitx", "sit", "tgz", "gz", "gzip", "bz2", "rar", "lzh", "lha"};
    public static final String DOCUMENT_TYPE = "document";
    public static final String AUDIO_TYPE = "audio";
    public static final String VIDEO_TYPE = "video";
    public static final String IMAGE_TYPE = "image";
    public static final String ARCHIVE_TYPE = "archive";
    public static final String APPLICATION_TYPE = "application";
    public static final String MAC_APPLICATION_TYPE = "application/mac";
    public static final String LINUX_APPLICATION_TYPE = "application/linux";
    public static final String WINDOWS_APPLICATION_TYPE = "application/win";

    public ResourceTypeTranslatorImpl() {
        this.addTypes(this.DOCUMENTS, DOCUMENT_TYPE);
        this.addTypes(this.AUDIO, AUDIO_TYPE);
        this.addTypes(this.IMAGE, IMAGE_TYPE);
        this.addTypes(this.VIDEO, VIDEO_TYPE);
        this.addTypes(this.OSX_APPLICATIONS, MAC_APPLICATION_TYPE);
        this.addTypes(this.LINUX_APPLICATIONS, LINUX_APPLICATION_TYPE);
        this.addTypes(this.WINDOWS_APPLICATIONS, WINDOWS_APPLICATION_TYPE);
        this.addTypes(this.GENERAL_APPLICATION, APPLICATION_TYPE);
        this.addTypes(this.ARCHIVE, ARCHIVE_TYPE);
    }

    private void addTypes(String[] extensions, String type) {
        for (String extension : extensions) {
            if (this.m_types.containsKey(extension)) {
                this.LOG.error("Duplicate extension: {} in type {}", (Object)extension, (Object)type);
                continue;
            }
            this.m_types.put(extension, type);
        }
    }

    @Override
    public String getType(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (StringUtils.isBlank((String)extension) || extension.length() > 7) {
            this.LOG.debug("No extension in file name: " + fileName);
            return "unknown";
        }
        if (!this.m_types.containsKey(extension)) {
            this.LOG.warn("No type for extension: " + extension + " in file name: " + fileName);
            return "unknown";
        }
        return this.m_types.get(extension);
    }

    @Override
    public boolean isAudioOrVideo(String type) {
        return type.equals(AUDIO_TYPE) || type.equals(VIDEO_TYPE);
    }
}

