/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JmxUtils.class);

    private JmxUtils() {
    }

    public static <T> ObjectName getObjectName(Class<T> clazz) {
        String domain = clazz.getPackage().getName();
        String className = clazz.getSimpleName();
        String objectName = domain + ":type=" + className;
        LOG.debug("Returning object name: {}", (Object)objectName);
        try {
            return new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Invalid ObjectName: " + objectName, (Throwable)e);
            throw new RuntimeException("Could not create ObjectName?", e);
        }
    }

    public static void register(MBeanServer mbs, Object obj) {
        ObjectName mBeanName = JmxUtils.getObjectName(obj.getClass());
        try {
            mbs.registerMBean(obj, mBeanName);
        }
        catch (InstanceAlreadyExistsException e) {
            LOG.error("Could not start JMX", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            LOG.error("Could not register", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOG.error("MBean error", (Throwable)e);
        }
    }
}

