/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.littleshoot.util.InputStreamHandler;
import org.littleshoot.util.IoUtils;
import org.littleshoot.util.NoOpWriteListener;
import org.littleshoot.util.WriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInputStreamHandler
implements InputStreamHandler {
    private final Logger LOG = LoggerFactory.getLogger(FileInputStreamHandler.class);
    private final File m_file;
    private WriteListener m_writeListener;

    public FileInputStreamHandler(File file) {
        this(file, new NoOpWriteListener());
    }

    public FileInputStreamHandler(File file, WriteListener writeListener) {
        this.LOG.trace("Creating stream handler for file: " + file);
        this.m_file = file;
        this.m_writeListener = writeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInputStream(InputStream is) throws IOException {
        this.LOG.trace("Handling input stream.");
        FileOutputStream os = new FileOutputStream(this.m_file);
        try {
            long bytesWritten = IoUtils.copy(is, (OutputStream)os, this.m_writeListener);
            this.LOG.trace("Wrote " + bytesWritten + " to file: " + this.m_file);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
    }
}

