/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.littleshoot.util.CandidateProvider;
import org.littleshoot.util.DnsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsSrvCandidateProvider
implements CandidateProvider<InetSocketAddress> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final CandidateProvider<InetSocketAddress> m_osSpecificProvider;
    private final String m_lookupName;
    private static final Pattern NSLOOKUP_PATTERN = Pattern.compile("\\s+port\\s+=\\s+(\\S+)\\s+svr hostname\\s+=\\s+(\\S+)");

    public DnsSrvCandidateProvider(String lookupName) {
        this.m_log.info("Existing nameservers: " + System.getProperty("sun.net.spi.nameservice.nameservers"));
        System.setProperty("sun.net.spi.nameservice.nameservers", "8.8.8.8,8.8.4.4");
        if (SystemUtils.IS_OS_WINDOWS) {
            String data = this.nativeData("nslookup", "-type=srv", lookupName, "8.8.8.8");
            this.m_osSpecificProvider = new OsCandidateProvider(data, NSLOOKUP_PATTERN);
        } else {
            String data = this.nativeData("dig", "@8.8.8.8", "SRV", lookupName);
            Pattern digMatcher = Pattern.compile(lookupName + ".\\s+\\d+\\s+IN\\s+SRV\\s+\\d+\\s+\\d+\\s+(\\d+)\\s+([\\w\\.]+)\\.");
            this.m_osSpecificProvider = new OsCandidateProvider(data, digMatcher);
        }
        this.m_lookupName = lookupName;
    }

    private String nativeData(String ... commands) {
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            Process process = pb.start();
            InputStream is = process.getInputStream();
            String data = IOUtils.toString((InputStream)is);
            this.m_log.info("Got data from native call: {}", (Object)data);
            return data;
        }
        catch (IOException e) {
            this.m_log.error("Error running commands: " + Arrays.asList(commands), (Throwable)e);
            return "";
        }
    }

    @Override
    public InetSocketAddress getCandidate() {
        InetSocketAddress candidate = this.m_osSpecificProvider.getCandidate();
        if (candidate == null) {
            try {
                Collection<InetSocketAddress> addresses = this.getJndiAddresses(this.m_lookupName);
                if (addresses.isEmpty()) {
                    this.m_log.error("Addresses are empty!");
                    return null;
                }
                return addresses.iterator().next();
            }
            catch (IOException e) {
                this.m_log.error("Error looking up JNDI addresses", (Throwable)e);
                return null;
            }
        }
        return candidate;
    }

    @Override
    public Collection<InetSocketAddress> getCandidates() {
        Collection<InetSocketAddress> candidates = this.m_osSpecificProvider.getCandidates();
        if (candidates == null || candidates.isEmpty()) {
            try {
                Collection<InetSocketAddress> addresses = this.getJndiAddresses(this.m_lookupName);
                return addresses;
            }
            catch (IOException e) {
                this.m_log.error("Error looking up JNDI addresses", (Throwable)e);
                return Collections.emptyList();
            }
        }
        return candidates;
    }

    private Collection<InetSocketAddress> getJndiAddresses(String lookupName) throws IOException {
        Attributes attr;
        DnsUtil util;
        try {
            util = new DnsUtil();
        }
        catch (NamingException e) {
            this.m_log.error("Could not create DNS util...", (Throwable)e);
            throw new IOExceptionWithCause("Could not create DNS util?", (Throwable)e);
        }
        try {
            attr = util.getSrvRecords(lookupName);
        }
        catch (NamingException e) {
            this.m_log.error("Invalid SRV name?", (Throwable)e);
            throw new IOExceptionWithCause("Invalid SRV name?", (Throwable)e);
        }
        Attribute srv = attr.get("SRV");
        int size = srv.size();
        LinkedList<InetSocketAddress> addresses = new LinkedList<InetSocketAddress>();
        for (int i = 0; i < size; ++i) {
            Object elem;
            try {
                elem = srv.get(i);
            }
            catch (NamingException e) {
                this.m_log.error("Invalid SRV name?", (Throwable)e);
                throw new IOExceptionWithCause("Invalid SRV name?", (Throwable)e);
            }
            String srvStr = elem.toString();
            Scanner scan = new Scanner(srvStr);
            scan.nextInt();
            scan.nextInt();
            int port = scan.nextInt();
            String fullAddress = scan.next();
            String address = fullAddress.endsWith(".") ? fullAddress.substring(0, fullAddress.length() - 1) : fullAddress;
            InetSocketAddress isa = new InetSocketAddress(address, port);
            addresses.add(isa);
        }
        Collections.shuffle(addresses);
        return new HashSet<InetSocketAddress>(addresses);
    }

    private static final class OsCandidateProvider
    implements CandidateProvider<InetSocketAddress> {
        private final Collection<InetSocketAddress> candidates = new LinkedList<InetSocketAddress>();

        private OsCandidateProvider(String data, Pattern pattern) {
            Matcher match = pattern.matcher(data);
            while (match.find()) {
                int port = Integer.parseInt(match.group(1));
                String host = match.group(2);
                this.candidates.add(new InetSocketAddress(host, port));
            }
        }

        @Override
        public InetSocketAddress getCandidate() {
            if (!this.candidates.isEmpty()) {
                return this.candidates.iterator().next();
            }
            return null;
        }

        @Override
        public Collection<InetSocketAddress> getCandidates() {
            return this.candidates;
        }
    }
}

