/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.IOException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.littleshoot.util.DefaultHttpClient;
import org.littleshoot.util.ResettingMultiThreadedHttpConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientImpl
implements DefaultHttpClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HttpClient httpClient;

    public DefaultHttpClientImpl(HttpConnectionManager connectionManager) {
        this.httpClient = new HttpClient(connectionManager);
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(40000);
        HttpClientParams params = this.httpClient.getParams();
        params.setSoTimeout(60000);
        String versionString = System.getProperty("org.lastbamboo.client.version", "0.00");
        params.setParameter("http.useragent", (Object)("LittleShoot/" + versionString));
    }

    public DefaultHttpClientImpl() {
        this((HttpConnectionManager)new ResettingMultiThreadedHttpConnectionManager());
    }

    @Override
    public HttpMethod get(String url) throws HttpException, IOException {
        GetMethod method = new GetMethod(url);
        return this.execute((HttpMethod)method);
    }

    @Override
    public HttpMethod post(String url) throws HttpException, IOException {
        PostMethod method = new PostMethod(url);
        return this.execute((HttpMethod)method);
    }

    @Override
    public int executeMethod(HttpMethod method) throws HttpException, IOException {
        this.execute(method);
        return method.getStatusCode();
    }

    private HttpMethod execute(HttpMethod method) throws HttpException, IOException {
        this.httpClient.executeMethod(method);
        return method;
    }

    @Override
    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpClient.getHttpConnectionManager();
    }

    @Override
    public HttpClientParams getParams() {
        return this.httpClient.getParams();
    }

    @Override
    public HttpState getState() {
        return this.httpClient.getState();
    }

    @Override
    public HostConfiguration getHostConfiguration() {
        return this.httpClient.getHostConfiguration();
    }
}

