/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.littleshoot.util.CandidateProvider;
import org.littleshoot.util.CollectionUtils;
import org.littleshoot.util.CollectionUtilsImpl;
import org.littleshoot.util.ConnectionEstablisher;
import org.littleshoot.util.ConnectionMaintainer;
import org.littleshoot.util.ConnectionMaintainerListener;
import org.littleshoot.util.None;
import org.littleshoot.util.NoneImpl;
import org.littleshoot.util.Optional;
import org.littleshoot.util.OptionalVisitor;
import org.littleshoot.util.Predicate;
import org.littleshoot.util.Some;
import org.littleshoot.util.SomeImpl;
import org.littleshoot.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionMaintainerImpl<T, ServerT>
implements ConnectionMaintainer<ServerT> {
    private final Logger LOG = LoggerFactory.getLogger(ConnectionMaintainerImpl.class);
    private final CollectionUtils m_collectionUtils = new CollectionUtilsImpl();
    private final ConnectionEstablisher<T, ServerT> m_establisher;
    private final CandidateProvider<T> m_candidateProvider;
    private final List<T> m_serverIdsToTry;
    private final List<T> m_usedServerIds;
    private final int m_minNumConnected;
    private final Map<T, ServerT> m_idMap;
    private final Thread m_thread;
    private int m_numConnected;
    private int m_outstanding;
    private Object m_mostRecentlyActiveId;
    private boolean m_sleepBeforeTryingToGetMoreCandidates;
    private volatile boolean m_firstRun = true;

    public ConnectionMaintainerImpl(ConnectionEstablisher<T, ServerT> establisher, CandidateProvider<T> candidateProvider, int minNumConnected) {
        this.m_establisher = establisher;
        this.m_candidateProvider = candidateProvider;
        this.m_serverIdsToTry = new LinkedList<T>();
        this.m_usedServerIds = new LinkedList<T>();
        this.m_minNumConnected = minNumConnected;
        this.m_idMap = new HashMap<T, ServerT>();
        ConnectionRunner runner = new ConnectionRunner();
        String threadName = this.getClass().getSimpleName() + "-" + runner.hashCode() + "-establisher-" + establisher.getClass().getSimpleName();
        this.m_thread = new Thread((Runnable)runner, threadName);
        this.m_thread.setDaemon(true);
        this.m_numConnected = 0;
        this.m_outstanding = 0;
        this.m_sleepBeforeTryingToGetMoreCandidates = false;
        this.m_mostRecentlyActiveId = null;
        this.m_firstRun = true;
    }

    private synchronized boolean isUsed(T candidate) {
        this.LOG.debug("Checking if used: " + candidate);
        this.LOG.debug("Used? " + this.m_usedServerIds.contains(candidate));
        return this.m_usedServerIds.contains(candidate);
    }

    private Optional<T> getServerIdToTry() {
        if (this.m_serverIdsToTry.isEmpty()) {
            Collection<T> moreCandidates = this.getMoreCandidates();
            if (moreCandidates.isEmpty()) {
                this.m_sleepBeforeTryingToGetMoreCandidates = true;
                return new NoneImpl();
            }
            this.m_sleepBeforeTryingToGetMoreCandidates = false;
            this.m_serverIdsToTry.addAll(moreCandidates);
            return new SomeImpl<T>(this.m_serverIdsToTry.remove(0));
        }
        return new SomeImpl<T>(this.m_serverIdsToTry.remove(0));
    }

    private Collection<T> getMoreCandidates() {
        UnusedServer unusedPredicate = new UnusedServer();
        LinkedList<T> servers = new LinkedList<T>();
        for (int tries = 0; servers.isEmpty() && tries < 3; ++tries) {
            this.LOG.debug("Trying to find candidate servers");
            if (this.m_sleepBeforeTryingToGetMoreCandidates) {
                this.LOG.debug("Long sleep...");
                ThreadUtils.safeSleep(60000L);
            } else if (!this.m_firstRun) {
                this.LOG.debug("Short sleep...");
                ThreadUtils.safeSleep(10000L);
            }
            this.m_firstRun = false;
            Collection<T> candidates = this.m_candidateProvider.getCandidates();
            this.LOG.debug("Found candidates...");
            Collection<T> unusedCandidates = this.m_collectionUtils.select(candidates, unusedPredicate);
            servers.addAll(unusedCandidates);
        }
        this.LOG.debug("Found this many candidate servers: " + servers.size());
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establish(T serverId) {
        this.LOG.debug("Connecting to: " + serverId);
        MyListener listener = new MyListener(serverId);
        ConnectionMaintainerImpl connectionMaintainerImpl = this;
        synchronized (connectionMaintainerImpl) {
            ++this.m_outstanding;
            this.m_usedServerIds.add(serverId);
        }
        this.m_establisher.establish(serverId, listener);
    }

    private synchronized boolean getShouldTryAnother() {
        return this.m_outstanding + this.m_numConnected < this.m_minNumConnected;
    }

    private void tryConnecting() {
        this.LOG.debug("Trying to connect");
        Optional<T> optionalServerIdToTry = this.getServerIdToTry();
        OptionalVisitor serverToTryVisitor = new OptionalVisitor<Void, T>(){

            @Override
            public Void visitNone(None<T> none) {
                ConnectionMaintainerImpl.this.LOG.debug("No connections to try...");
                return null;
            }

            @Override
            public Void visitSome(Some<T> some) {
                ConnectionMaintainerImpl.this.LOG.debug("Establishing connection...");
                ConnectionMaintainerImpl.this.establish(some.object());
                return null;
            }
        };
        optionalServerIdToTry.accept(serverToTryVisitor);
    }

    @Override
    public void start() {
        if (!this.m_thread.isAlive()) {
            this.m_thread.start();
        } else {
            this.LOG.warn("We should not be trying to register multiple times");
        }
    }

    @Override
    public synchronized Optional<ServerT> getMostRecentlyActive() {
        if (this.m_idMap.containsKey(this.m_mostRecentlyActiveId)) {
            return new SomeImpl<ServerT>(this.m_idMap.get(this.m_mostRecentlyActiveId));
        }
        return new NoneImpl();
    }

    @Override
    public synchronized Collection<ServerT> getConnectedServers() {
        this.LOG.debug("m_idMap.size: " + this.m_idMap.size());
        return Collections.unmodifiableCollection(this.m_idMap.values());
    }

    private class MyListener
    implements ConnectionMaintainerListener<ServerT> {
        private final T m_serverId;

        private MyListener(T serverId) {
            this.m_serverId = serverId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connected(ServerT server) {
            ConnectionMaintainerImpl.this.LOG.debug("Got connected: " + this.m_serverId);
            ConnectionMaintainerImpl connectionMaintainerImpl = ConnectionMaintainerImpl.this;
            synchronized (connectionMaintainerImpl) {
                --ConnectionMaintainerImpl.this.m_outstanding;
                ++ConnectionMaintainerImpl.this.m_numConnected;
                ConnectionMaintainerImpl.this.m_idMap.put(this.m_serverId, server);
                ConnectionMaintainerImpl.this.notify();
            }
            ConnectionMaintainerImpl.this.m_mostRecentlyActiveId = this.m_serverId;
        }

        @Override
        public void reconnected() {
            ConnectionMaintainerImpl.this.m_mostRecentlyActiveId = this.m_serverId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionFailed() {
            ConnectionMaintainerImpl.this.LOG.debug("Got connectionFailed: " + this.m_serverId);
            ConnectionMaintainerImpl connectionMaintainerImpl = ConnectionMaintainerImpl.this;
            synchronized (connectionMaintainerImpl) {
                --ConnectionMaintainerImpl.this.m_outstanding;
                ConnectionMaintainerImpl.this.notify();
                ConnectionMaintainerImpl.this.m_usedServerIds.remove(this.m_serverId);
                ConnectionMaintainerImpl.this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnected() {
            ConnectionMaintainerImpl.this.LOG.debug("Got disconnected: " + this.m_serverId);
            ConnectionMaintainerImpl connectionMaintainerImpl = ConnectionMaintainerImpl.this;
            synchronized (connectionMaintainerImpl) {
                --ConnectionMaintainerImpl.this.m_numConnected;
                ConnectionMaintainerImpl.this.m_idMap.remove(this.m_serverId);
                ConnectionMaintainerImpl.this.m_usedServerIds.remove(this.m_serverId);
                ConnectionMaintainerImpl.this.notify();
            }
        }
    }

    private class ConnectionRunner
    implements Runnable {
        private ConnectionRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ConnectionMaintainerImpl connectionMaintainerImpl = ConnectionMaintainerImpl.this;
                synchronized (connectionMaintainerImpl) {
                    while (!ConnectionMaintainerImpl.this.getShouldTryAnother()) {
                        ConnectionMaintainerImpl.this.LOG.debug("Waiting to try another");
                        ThreadUtils.safeWait(ConnectionMaintainerImpl.this);
                    }
                }
                try {
                    if (ConnectionMaintainerImpl.this.LOG.isDebugEnabled()) {
                        ConnectionMaintainerImpl.this.LOG.debug("Trying to connect...");
                    }
                    ConnectionMaintainerImpl.this.tryConnecting();
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    ConnectionMaintainerImpl.this.LOG.warn("Exception while trying to connect", (Throwable)runtimeException);
                    continue;
                }
                break;
            }
        }
    }

    private class UnusedServer
    implements Predicate<T> {
        private UnusedServer() {
        }

        @Override
        public boolean evaluate(T object) {
            return !ConnectionMaintainerImpl.this.isUsed(object);
        }
    }
}

