/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BeanUtils.class);

    private BeanUtils() {
    }

    public static Map<String, String> mapBean(Object bean) {
        return BeanUtils.mapBean(bean, "");
    }

    public static Map<String, String> mapBean(Object bean, String exclude) {
        HashSet<String> excludes = new HashSet<String>();
        if (!StringUtils.isBlank((String)exclude)) {
            excludes.add(exclude);
        }
        return BeanUtils.mapBean(bean, excludes);
    }

    public static Map<String, String> mapBean(Object bean, Set<String> excludes) {
        excludes.add("getClass");
        Object[] emptyParams = new Object[]{};
        Method[] methods = bean.getClass().getMethods();
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Method method : methods) {
            String name;
            if (method.getParameterTypes().length > 0 || !(name = method.getName()).startsWith("get") || excludes.contains(name)) continue;
            LOG.debug("Calling method: {}", (Object)name);
            try {
                Object returnVal = method.invoke(bean, emptyParams);
                LOG.debug("Got: {}", returnVal);
                String beanValue = String.valueOf(returnVal);
                String beanData = StringUtils.substringAfter((String)name, (String)"get");
                fields.put(StringUtils.uncapitalize((String)beanData), beanValue);
            }
            catch (IllegalAccessException e) {
                LOG.debug("Could not access method: " + method.toGenericString(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.debug("Could not invoke method: " + method.toGenericString(), (Throwable)e);
            }
        }
        return fields;
    }

    public static void populateBean(Object bean, Map<String, String> params) {
        Method[] methods;
        for (Method method : methods = bean.getClass().getMethods()) {
            Object toAssign;
            String fieldName;
            String str;
            String name;
            Class<?>[] types = method.getParameterTypes();
            int length = types.length;
            if (length != 1 || !(name = method.getName()).startsWith("set") || (str = params.get(fieldName = name.substring(3).toLowerCase())) == null) continue;
            String val = str.trim();
            Class<Object> type = types[0];
            if (type.isAssignableFrom(String.class)) {
                toAssign = val;
            } else if (type.isAssignableFrom(Integer.TYPE)) {
                toAssign = Integer.parseInt(val);
            } else if (type.isAssignableFrom(Boolean.TYPE)) {
                toAssign = BeanUtils.toBoolean(val);
            } else if (type.isAssignableFrom(Boolean.class)) {
                toAssign = BeanUtils.toBoolean(val);
            } else if (type.isAssignableFrom(File.class)) {
                toAssign = new File(val);
            } else if (type.isAssignableFrom(URI.class)) {
                try {
                    toAssign = new URI(val);
                }
                catch (URISyntaxException e) {
                    LOG.error("Error building bean", (Throwable)e);
                    throw new IllegalArgumentException("Error building bean", e);
                }
            } else if (type.isAssignableFrom(Integer.class)) {
                toAssign = Integer.parseInt(val);
            } else if (type.isAssignableFrom(Integer.TYPE)) {
                toAssign = Integer.parseInt(val);
            } else if (type.isAssignableFrom(Float.class)) {
                toAssign = Float.valueOf(Float.parseFloat(val));
            } else if (type.isAssignableFrom(Float.TYPE)) {
                toAssign = Float.valueOf(Float.parseFloat(val));
            } else if (type.isAssignableFrom(Double.class)) {
                toAssign = Double.parseDouble(val);
            } else if (type.isAssignableFrom(Double.TYPE)) {
                toAssign = Double.parseDouble(val);
            } else if (type.isAssignableFrom(Long.class)) {
                toAssign = Long.parseLong(val);
            } else if (type.isAssignableFrom(Long.TYPE)) {
                toAssign = Long.parseLong(val);
            } else {
                String msg = "Could not handle type: {}" + type.getName() + " key: " + fieldName;
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            try {
                method.invoke(bean, toAssign);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Could not invoke method", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Could not invoke method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error("Could not invoke method", (Throwable)e);
            }
        }
    }

    private static Object toBoolean(String val) {
        if (val.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (val.equalsIgnoreCase("off")) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean(val);
    }
}

