/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.transaction;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.transaction.StunClientTransaction;
import org.littleshoot.stun.stack.transaction.StunClientTransactionImpl;
import org.littleshoot.stun.stack.transaction.StunTransactionListener;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunTransactionTrackerImpl
implements StunTransactionTracker<StunMessage>,
StunTransactionListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<UUID, StunClientTransaction<StunMessage>> transactions = new ConcurrentHashMap<UUID, StunClientTransaction<StunMessage>>();

    @Override
    public void addTransaction(StunMessage request, StunTransactionListener listener, InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        LinkedList<StunTransactionListener> transactionListeners = new LinkedList<StunTransactionListener>();
        transactionListeners.add(listener);
        StunClientTransactionImpl ct = new StunClientTransactionImpl(request, transactionListeners, remoteAddress);
        this.trackTransaction(ct);
    }

    private void trackTransaction(StunClientTransaction<StunMessage> ct) {
        this.log.debug("Tracking transaction...");
        StunMessage message = ct.getRequest();
        UUID key = this.getTransactionKey(message);
        this.transactions.put(key, ct);
        ct.addListener(this);
    }

    @Override
    public StunClientTransaction<StunMessage> getClientTransaction(StunMessage message) {
        this.log.debug("Accessing client transaction...");
        UUID key = this.getTransactionKey(message);
        StunClientTransaction<StunMessage> ct = this.transactions.get(key);
        if (ct == null) {
            this.log.debug("Nothing known about transaction: " + key);
            this.log.debug("Known transactions: " + this.transactions.keySet());
        }
        return ct;
    }

    private UUID getTransactionKey(StunMessage message) {
        return message.getTransactionId();
    }

    public Object onTransactionFailed(StunMessage request, StunMessage response) {
        this.log.debug("Transaction failed...");
        return this.removeTransaction(request);
    }

    public Object onTransactionSucceeded(StunMessage request, StunMessage response) {
        this.log.debug("Transaction succeeded...");
        return this.removeTransaction(request);
    }

    private Object removeTransaction(StunMessage message) {
        UUID key = this.getTransactionKey(message);
        this.log.debug("Removing transaction with key '" + key + "'");
        this.transactions.remove(key);
        return null;
    }
}

