/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack;

import java.net.PortUnreachableException;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandlerAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.util.SessionUtil;
import org.littleshoot.stun.stack.message.ConnectErrorStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.StunMessageVisitorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunIoHandler<T>
extends IoHandlerAdapter {
    private final Logger m_log = LoggerFactory.getLogger(StunIoHandler.class);
    private final StunMessageVisitorFactory m_visitorFactory;

    public StunIoHandler(StunMessageVisitorFactory visitorFactory) {
        this.m_visitorFactory = visitorFactory;
    }

    public void messageReceived(IoSession session, Object message) {
        this.m_log.debug("Received message: {}", message);
        if (session.isClosing() || !session.isConnected()) {
            this.m_log.debug("Ignoring message on closing session...");
            return;
        }
        StunMessage stunMessage = (StunMessage)message;
        StunMessageVisitor visitor = this.m_visitorFactory.createVisitor(session);
        this.m_log.debug("Sending message to visitor: {}", visitor);
        stunMessage.accept(visitor);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        this.m_log.debug("Exception on STUN IoHandler", cause);
        if (cause instanceof PortUnreachableException) {
            ConnectErrorStunMessage icmpError = new ConnectErrorStunMessage();
            this.messageReceived(session, icmpError);
        } else {
            this.m_log.warn("Exception on STUN IoHandler for session: " + session, cause);
            session.close();
        }
    }

    public void sessionCreated(IoSession session) throws Exception {
        SessionUtil.initialize((IoSession)session);
        session.setIdleTime(IdleStatus.BOTH_IDLE, 100);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        this.m_log.debug("Killing idle session");
        session.close();
    }
}

