/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.littleshoot.proxy.KeyStoreManager;

public class SslContextFactory {
    private static final String PROTOCOL = "TLS";
    private final SSLContext SERVER_CONTEXT;
    private final SSLContext CLIENT_CONTEXT;

    public SslContextFactory(KeyStoreManager ksm) {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        SSLContext serverContext = null;
        SSLContext clientContext = null;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(ksm.keyStoreAsInputStream(), ksm.getKeyStorePassword());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, ksm.getCertificatePassword());
            serverContext = SSLContext.getInstance(PROTOCOL);
            serverContext.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
        try {
            clientContext = SSLContext.getInstance(PROTOCOL);
            clientContext.init(null, ksm.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the client-side SSLContext", e);
        }
        this.SERVER_CONTEXT = serverContext;
        this.CLIENT_CONTEXT = clientContext;
    }

    public SSLContext getServerContext() {
        return this.SERVER_CONTEXT;
    }

    public SSLContext getClientContext() {
        return this.CLIENT_CONTEXT;
    }
}

