/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy;

import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.littleshoot.proxy.DefaultRelayPipelineFactory;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.ProxyUtils;
import org.littleshoot.proxy.RelayListener;
import org.littleshoot.proxy.RelayPipelineFactoryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRelayPipelineFactoryFactory
implements RelayPipelineFactoryFactory {
    private String chainProxyHostAndPort;
    private Map<String, HttpFilter> filters;
    private ChannelGroup channelGroup;
    private HttpRequestFilter requestFilter;

    public DefaultRelayPipelineFactoryFactory(String chainProxyHostAndPort, Map<String, HttpFilter> filters, HttpRequestFilter requestFilter, ChannelGroup channelGroup) {
        this.chainProxyHostAndPort = chainProxyHostAndPort;
        this.filters = filters;
        this.channelGroup = channelGroup;
        this.requestFilter = requestFilter;
    }

    @Override
    public ChannelPipelineFactory getRelayPipelineFactory(HttpRequest httpRequest, Channel browserToProxyChannel, RelayListener relayListener) {
        String hostAndPort = this.chainProxyHostAndPort != null ? this.chainProxyHostAndPort : ProxyUtils.parseHostAndPort(httpRequest);
        return new DefaultRelayPipelineFactory(hostAndPort, httpRequest, relayListener, browserToProxyChannel, this.channelGroup, this.filters, this.requestFilter, this.chainProxyHostAndPort);
    }
}

