/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.undercouch.bson4jackson.BsonParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.jackson.BsonModule;
import org.litote.kmongo.jackson.ExtendedJsonModule;
import org.litote.kmongo.jackson.FilterIdIntrospector;
import org.litote.kmongo.jackson.KMongoBsonFactory;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lorg/litote/kmongo/jackson/ObjectMapperFactory;", "", "()V", "createBsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createExtendedJsonObjectMapper", "createFilterIdObjectMapper", "objectMapper", "kmongo-shared"})
public final class ObjectMapperFactory {
    public static final ObjectMapperFactory INSTANCE;

    @NotNull
    public final ObjectMapper createExtendedJsonObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule()).registerModule((Module)new ExtendedJsonModule());
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper()\n         \u2026ule(ExtendedJsonModule())");
        return objectMapper;
    }

    @NotNull
    public final ObjectMapper createBsonObjectMapper() {
        KMongoBsonFactory bsonFactory = new KMongoBsonFactory();
        bsonFactory.enable(BsonParser.Feature.HONOR_DOCUMENT_LENGTH);
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)bsonFactory).registerModule((Module)new de.undercouch.bson4jackson.BsonModule()).registerModule((Module)new KotlinModule()).registerModule((Module)new BsonModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"ObjectMapper(bsonFactory\u2026NKNOWN_PROPERTIES, false)");
        return objectMapper;
    }

    @NotNull
    public final ObjectMapper createFilterIdObjectMapper(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"objectMapper");
        ObjectMapper newObjectMapper = objectMapper.copy();
        newObjectMapper.setFilterProvider((FilterProvider)FilterIdIntrospector.IdPropertyFilterProvider.INSTANCE);
        newObjectMapper.setAnnotationIntrospector((AnnotationIntrospector)FilterIdIntrospector.INSTANCE);
        ObjectMapper objectMapper2 = newObjectMapper;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper2, (String)"newObjectMapper");
        return objectMapper2;
    }

    private ObjectMapperFactory() {
        INSTANCE = this;
    }

    static {
        new ObjectMapperFactory();
    }
}

