/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J%\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00020)H\u0016\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u00028\u00002\u0006\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010,J\u0017\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Lorg/litote/kmongo/jackson/JacksonCodec;", "T", "Lorg/bson/codecs/Codec;", "Lorg/bson/codecs/CollectibleCodec;", "bsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "codecRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "type", "Ljava/lang/Class;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/bson/codecs/configuration/CodecRegistry;Ljava/lang/Class;)V", "getBsonObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getCodecRegistry", "()Lorg/bson/codecs/configuration/CodecRegistry;", "idField", "Ljava/lang/reflect/Field;", "getIdField", "()Ljava/lang/reflect/Field;", "idField$delegate", "Lkotlin/Lazy;", "rawBsonDocumentCodec", "Lorg/bson/RawBsonDocument;", "getType", "()Ljava/lang/Class;", "decode", "reader", "Lorg/bson/BsonReader;", "decoderContext", "Lorg/bson/codecs/DecoderContext;", "(Lorg/bson/BsonReader;Lorg/bson/codecs/DecoderContext;)Ljava/lang/Object;", "documentHasId", "", "document", "(Ljava/lang/Object;)Z", "encode", "", "writer", "Lorg/bson/BsonWriter;", "value", "encoderContext", "Lorg/bson/codecs/EncoderContext;", "(Lorg/bson/BsonWriter;Ljava/lang/Object;Lorg/bson/codecs/EncoderContext;)V", "generateIdIfAbsentFromDocument", "(Ljava/lang/Object;)Ljava/lang/Object;", "getDocumentId", "Lorg/bson/BsonValue;", "(Ljava/lang/Object;)Lorg/bson/BsonValue;", "getEncoderClass", "kmongo-shared"})
public final class JacksonCodec<T>
implements Codec<T>,
CollectibleCodec<T> {
    private final Codec<RawBsonDocument> rawBsonDocumentCodec;
    private final Lazy idField$delegate;
    @NotNull
    private final ObjectMapper bsonObjectMapper;
    @NotNull
    private final CodecRegistry codecRegistry;
    @NotNull
    private final Class<T> type;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final Field getIdField() {
        Lazy lazy = this.idField$delegate;
        JacksonCodec jacksonCodec = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Field)lazy.getValue();
    }

    public T decode(@NotNull BsonReader reader, @NotNull DecoderContext decoderContext) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)decoderContext, (String)"decoderContext");
        try {
            return (T)this.bsonObjectMapper.readValue(((RawBsonDocument)this.rawBsonDocumentCodec.decode(reader, decoderContext)).getByteBuffer().array(), this.type);
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    public void encode(@NotNull BsonWriter writer, T value, @NotNull EncoderContext encoderContext) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)encoderContext, (String)"encoderContext");
        try {
            byte[] e = this.bsonObjectMapper.writeValueAsBytes(value);
            this.rawBsonDocumentCodec.encode(writer, (Object)new RawBsonDocument(e), encoderContext);
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    @NotNull
    public Class<T> getEncoderClass() {
        return this.type;
    }

    @Nullable
    public BsonValue getDocumentId(T document) {
        BsonValue bsonValue;
        if (this.getIdField() == null) {
            throw (Throwable)new IllegalStateException(this.type + " has no id field");
        }
        Field field = this.getIdField();
        if (field == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.Field");
        }
        Object idValue = field.get(document);
        if (idValue == null) {
            throw (Throwable)new IllegalStateException(this.type + " has null id");
        }
        Object object = idValue;
        if (object instanceof ObjectId) {
            bsonValue = (BsonValue)new BsonObjectId((ObjectId)idValue);
        } else if (object instanceof String) {
            bsonValue = (BsonValue)new BsonString((String)idValue);
        } else {
            throw (Throwable)new IllegalArgumentException("id field type not supported : " + this.getIdField());
        }
        return bsonValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean documentHasId(T document) {
        if (this.getIdField() == null) return false;
        Field field = this.getIdField();
        if (field == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.Field");
        }
        if (field.get(document) == null) return false;
        return true;
    }

    public T generateIdIfAbsentFromDocument(T document) {
        if (this.getIdField() != null) {
            Field field = this.getIdField();
            if (field == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.Field");
            }
            Field id = field;
            Object idValue = id.get(document);
            if (idValue == null) {
                Class<?> fieldType = id.getType();
                if (Intrinsics.areEqual(fieldType, String.class)) {
                    id.set(document, ObjectId.get().toString());
                } else if (Intrinsics.areEqual(fieldType, ObjectId.class)) {
                    id.set(document, ObjectId.get());
                } else {
                    throw (Throwable)new IllegalArgumentException("generation for id field type not supported : " + this.getIdField());
                }
            }
        }
        return document;
    }

    @NotNull
    public final ObjectMapper getBsonObjectMapper() {
        return this.bsonObjectMapper;
    }

    @NotNull
    public final CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @NotNull
    public final Class<T> getType() {
        return this.type;
    }

    public JacksonCodec(@NotNull ObjectMapper bsonObjectMapper, @NotNull CodecRegistry codecRegistry, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)bsonObjectMapper, (String)"bsonObjectMapper");
        Intrinsics.checkParameterIsNotNull((Object)codecRegistry, (String)"codecRegistry");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        this.bsonObjectMapper = bsonObjectMapper;
        this.codecRegistry = codecRegistry;
        this.type = type;
        this.idField$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Field>(this){
            final /* synthetic */ JacksonCodec this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Field invoke() {
                Field field;
                Field field2;
                try {
                    field2 = this.this$0.getType().getDeclaredField("_id");
                }
                catch (NoSuchFieldException e) {
                    field2 = null;
                }
                Field f = field2;
                if (f == null) {
                    field = null;
                } else {
                    void var1_3;
                    f.setAccessible(true);
                    field = var1_3;
                }
                return field;
            }
            {
                this.this$0 = jacksonCodec;
                super(0);
            }
        }));
        Codec codec = this.codecRegistry.get(RawBsonDocument.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)codec, (String)"codecRegistry.get(RawBsonDocument::class.java)");
        this.rawBsonDocumentCodec = codec;
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JacksonCodec.class), "idField", "getIdField()Ljava/lang/reflect/Field;"))};
    }
}

