/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.serialization;

import com.github.jershell.kbson.Configuration;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerialName;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.id.MongoId;
import org.litote.kmongo.id.MongoProperty;
import org.litote.kmongo.serialization.BaseRegistryWithoutCustomSerializers;
import org.litote.kmongo.serialization.IdControllerKt;
import org.litote.kmongo.serialization.KMongoSerializationRepositoryKt;
import org.litote.kmongo.serialization.SerializationCodecRegistry;
import org.litote.kmongo.service.ClassMappingTypeService;
import org.litote.kmongo.util.ObjectMappingConfiguration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J7\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\u00190\u00152\u0006\u0010\u001b\u001a\u0002H\bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/litote/kmongo/serialization/SerializationClassMappingTypeService;", "Lorg/litote/kmongo/service/ClassMappingTypeService;", "()V", "codecRegistryWithEncodeNull", "Lorg/bson/codecs/configuration/CodecRegistry;", "codecRegistryWithNonEncodeNull", "calculatePath", "", "T", "property", "Lkotlin/reflect/KProperty;", "coreCodecRegistry", "baseCodecRegistry", "filterBaseCodecRegistry", "filterIdToBson", "Lorg/bson/BsonDocument;", "obj", "", "filterNullProperties", "", "findIdProperty", "Lkotlin/reflect/KProperty1;", "type", "Lkotlin/reflect/KClass;", "getIdValue", "R", "idProperty", "instance", "(Lkotlin/reflect/KProperty1;Ljava/lang/Object;)Ljava/lang/Object;", "priority", "", "toExtendedJson", "kmongo-serialization-mapping"})
public final class SerializationClassMappingTypeService
implements ClassMappingTypeService {
    private volatile CodecRegistry codecRegistryWithNonEncodeNull;
    private volatile CodecRegistry codecRegistryWithEncodeNull;

    public int priority() {
        return 200;
    }

    @NotNull
    public BsonDocument filterIdToBson(@NotNull Object obj, boolean filterNullProperties) {
        CodecRegistry codecRegistry;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        BsonDocument doc = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(doc);
        if (filterNullProperties) {
            codecRegistry = this.codecRegistryWithNonEncodeNull;
            if (codecRegistry == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codecRegistryWithNonEncodeNull");
                codecRegistry = null;
            }
        } else {
            codecRegistry = this.codecRegistryWithEncodeNull;
            if (codecRegistry == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codecRegistryWithEncodeNull");
                codecRegistry = null;
            }
        }
        codecRegistry.get(obj.getClass()).encode((BsonWriter)writer, obj, EncoderContext.builder().build());
        writer.flush();
        doc.remove((Object)"_id");
        return doc;
    }

    @NotNull
    public String toExtendedJson(@Nullable Object obj) {
        String string;
        if (obj == null) {
            string = "null";
        } else {
            StringWriter writer = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)writer, JsonWriterSettings.builder().indent(false).outputMode(JsonMode.RELAXED).build());
            jsonWriter.writeStartDocument();
            jsonWriter.writeName("tmp");
            CodecRegistry codecRegistry = this.codecRegistryWithNonEncodeNull;
            if (codecRegistry == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codecRegistryWithNonEncodeNull");
                codecRegistry = null;
            }
            codecRegistry.get(obj.getClass()).encode((BsonWriter)jsonWriter, obj, EncoderContext.builder().build());
            jsonWriter.writeEndDocument();
            String $this$toExtendedJson_u24lambda_u240 = writer.toString();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$toExtendedJson_u24lambda_u240, (String)"toExtendedJson$lambda$0");
            String string2 = $this$toExtendedJson_u24lambda_u240.substring(8, $this$toExtendedJson_u24lambda_u240.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        return string;
    }

    @Nullable
    public KProperty1<?, ?> findIdProperty(@NotNull KClass<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return IdControllerKt.getIdController().findIdProperty(type);
    }

    @Nullable
    public <T, R> R getIdValue(@NotNull KProperty1<T, ? extends R> idProperty2, T instance) {
        Intrinsics.checkNotNullParameter(idProperty2, (String)"idProperty");
        return IdControllerKt.getIdController().getIdValue(idProperty2, instance);
    }

    @NotNull
    public CodecRegistry coreCodecRegistry(@NotNull CodecRegistry baseCodecRegistry) {
        Intrinsics.checkNotNullParameter((Object)baseCodecRegistry, (String)"baseCodecRegistry");
        SerializationCodecRegistry withNonEncodeNull = new SerializationCodecRegistry(Configuration.copy$default((Configuration)KMongoSerializationRepositoryKt.getConfiguration(), (boolean)false, null, (boolean)true, (int)3, null));
        this.codecRegistryWithNonEncodeNull = this.codecRegistryWithCustomCodecs(this.filterBaseCodecRegistry(baseCodecRegistry), withNonEncodeNull);
        SerializationCodecRegistry withEncodeNull = new SerializationCodecRegistry(Configuration.copy$default((Configuration)KMongoSerializationRepositoryKt.getConfiguration(), (boolean)false, null, (boolean)false, (int)3, null));
        this.codecRegistryWithEncodeNull = this.codecRegistryWithCustomCodecs(this.filterBaseCodecRegistry(baseCodecRegistry), withEncodeNull);
        return new CodecRegistry(withEncodeNull, withNonEncodeNull){
            final /* synthetic */ SerializationCodecRegistry $withEncodeNull;
            final /* synthetic */ SerializationCodecRegistry $withNonEncodeNull;
            {
                this.$withEncodeNull = $withEncodeNull;
                this.$withNonEncodeNull = $withNonEncodeNull;
            }

            @NotNull
            public <T> Codec<T> get(@NotNull Class<T> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                return ObjectMappingConfiguration.INSTANCE.getSerializeNull() ? this.$withEncodeNull.get(clazz) : this.$withNonEncodeNull.get(clazz);
            }

            @NotNull
            public <T> Codec<T> get(@NotNull Class<T> clazz, @NotNull CodecRegistry registry) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
                return ObjectMappingConfiguration.INSTANCE.getSerializeNull() ? this.$withEncodeNull.get(clazz, registry) : this.$withNonEncodeNull.get(clazz, registry);
            }
        };
    }

    @NotNull
    public CodecRegistry filterBaseCodecRegistry(@NotNull CodecRegistry baseCodecRegistry) {
        Intrinsics.checkNotNullParameter((Object)baseCodecRegistry, (String)"baseCodecRegistry");
        return new BaseRegistryWithoutCustomSerializers(baseCodecRegistry);
    }

    @NotNull
    public <T> String calculatePath(@NotNull KProperty<? extends T> property) {
        Object object;
        Object v0;
        block7: {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)property;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof SerialName)) continue;
                v0 = element$iv$iv;
                break block7;
            }
            v0 = null;
        }
        if ((object = (SerialName)((Annotation)((SerialName)v0))) == null || (object = object.value()) == null) {
            String string;
            Object v2;
            block8: {
                KAnnotatedElement $this$hasAnnotation$iv = (KAnnotatedElement)property;
                boolean $i$f$hasAnnotation = false;
                KAnnotatedElement $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                    Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                    boolean bl = false;
                    if (!(it$iv$iv instanceof MongoId)) continue;
                    v2 = element$iv$iv$iv;
                    break block8;
                }
                v2 = null;
            }
            boolean bl = (Annotation)((MongoId)v2) != null;
            if (bl) {
                string = "_id";
            } else {
                Object v5;
                block9: {
                    KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)property;
                    boolean $i$f$findAnnotation = false;
                    Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                        Annotation it$iv = (Annotation)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it$iv instanceof MongoProperty)) continue;
                        v5 = element$iv$iv;
                        break block9;
                    }
                    v5 = null;
                }
                MongoProperty mongoProperty = (MongoProperty)((Annotation)((MongoProperty)v5));
                string = object = mongoProperty != null ? mongoProperty.value() : null;
            }
            if (string == null) {
                object = property.getName();
            }
        }
        return object;
    }

    public boolean getDefaultNullSerialization() {
        return ClassMappingTypeService.DefaultImpls.getDefaultNullSerialization((ClassMappingTypeService)this);
    }

    @NotNull
    public CodecRegistry codecRegistry(@NotNull CodecRegistry baseCodecRegistry) {
        return ClassMappingTypeService.DefaultImpls.codecRegistry((ClassMappingTypeService)this, (CodecRegistry)baseCodecRegistry);
    }

    @NotNull
    public CodecRegistry codecRegistryWithCustomCodecs(@NotNull CodecRegistry baseCodecRegistry, @NotNull CodecRegistry coreCodeRegistry) {
        return ClassMappingTypeService.DefaultImpls.codecRegistryWithCustomCodecs((ClassMappingTypeService)this, (CodecRegistry)baseCodecRegistry, (CodecRegistry)coreCodeRegistry);
    }

    @NotNull
    public <T> String getPath(@NotNull KProperty<? extends T> property) {
        return ClassMappingTypeService.DefaultImpls.getPath((ClassMappingTypeService)this, property);
    }

    public void resetConfiguration() {
        ClassMappingTypeService.DefaultImpls.resetConfiguration((ClassMappingTypeService)this);
    }
}

