/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.serialization;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.serialization.LocalDateTimeSerializer;
import org.litote.kmongo.serialization.TemporalExtendedJsonSerializer;
import org.litote.kmongo.serialization.ZonedDateTimeSerializer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lorg/litote/kmongo/serialization/LocalDateSerializer;", "Lorg/litote/kmongo/serialization/TemporalExtendedJsonSerializer;", "Ljava/time/LocalDate;", "()V", "epochMillis", "", "temporal", "instantiate", "date", "kmongo-serialization-mapping"})
public final class LocalDateSerializer
extends TemporalExtendedJsonSerializer<LocalDate> {
    @NotNull
    public static final LocalDateSerializer INSTANCE;

    @Override
    public long epochMillis(@NotNull LocalDate temporal) {
        Intrinsics.checkNotNullParameter((Object)temporal, (String)"temporal");
        ZonedDateTime zonedDateTime = temporal.atStartOfDay(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"temporal.atStartOfDay(ZoneOffset.UTC)");
        return ZonedDateTimeSerializer.INSTANCE.epochMillis(zonedDateTime);
    }

    @Override
    @NotNull
    public LocalDate instantiate(long date) {
        LocalDate localDate = LocalDateTimeSerializer.INSTANCE.instantiate(date).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDateTimeSerializer.\u2026tiate(date).toLocalDate()");
        return localDate;
    }

    private LocalDateSerializer() {
    }

    static {
        LocalDateSerializer localDateSerializer;
        INSTANCE = localDateSerializer = new LocalDateSerializer();
    }
}

