/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.serialization;

import com.github.jershell.kbson.FlexibleDecoder;
import com.github.jershell.kbson.ObjectIdSerializer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PrimitiveKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialDescriptorBuilderKt;
import kotlinx.serialization.SerializationException;
import org.bson.AbstractBsonReader;
import org.bson.BsonType;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import org.litote.kmongo.id.IdGenerator;
import org.litote.kmongo.id.IdTransformer;
import org.litote.kmongo.id.ObjectIdGenerator;
import org.litote.kmongo.serialization.IdSerializer$WhenMappings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0013H\u0002J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/litote/kmongo/serialization/IdSerializer;", "T", "Lorg/litote/kmongo/Id;", "Lkotlinx/serialization/KSerializer;", "shouldBeStringId", "", "(Z)V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "getShouldBeStringId", "()Z", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Lorg/litote/kmongo/Id;", "deserializeObjectId", "", "Lcom/github/jershell/kbson/FlexibleDecoder;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "obj", "(Lkotlinx/serialization/Encoder;Lorg/litote/kmongo/Id;)V", "kmongo-serialization-mapping"})
public final class IdSerializer<T extends Id<?>>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    private final boolean shouldBeStringId;

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Id id = IdTransformer.INSTANCE.wrapId(this.deserializeObjectId((FlexibleDecoder)decoder));
        if (id == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object deserializeObjectId(FlexibleDecoder decoder) {
        String string;
        if (decoder.getReader().getState() == AbstractBsonReader.State.NAME) {
            String keyId = decoder.getReader().readName();
            string = this.shouldBeStringId || Intrinsics.areEqual((Object)IdGenerator.Companion.getDefaultGenerator(), (Object)ObjectIdGenerator.INSTANCE) ^ true ? keyId : new ObjectId(keyId);
        } else {
            BsonType bsonType = decoder.getReader().getCurrentBsonType();
            if (bsonType == null) throw (Throwable)new SerializationException("Unsupported " + decoder.getReader().getCurrentBsonType() + " reading object id", null, 2, null);
            switch (IdSerializer$WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
                case 1: {
                    string = decoder.decodeString();
                    break;
                }
                case 2: {
                    string = decoder.getReader().readObjectId();
                    break;
                }
                default: {
                    throw (Throwable)new SerializationException("Unsupported " + decoder.getReader().getCurrentBsonType() + " reading object id", null, 2, null);
                }
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (decoder.reader.state\u2026)\n            }\n        }");
        return string;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull T obj) {
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Object object = IdTransformer.INSTANCE.unwrapId(obj);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        Object object2 = it;
        if (object2 instanceof String) {
            encoder.encodeString((String)it);
        } else if (object2 instanceof ObjectId) {
            ObjectIdSerializer.INSTANCE.serialize(encoder, (ObjectId)it);
        } else {
            String string = "unsupported id type " + obj;
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public final boolean getShouldBeStringId() {
        return this.shouldBeStringId;
    }

    public IdSerializer(boolean shouldBeStringId) {
        this.shouldBeStringId = shouldBeStringId;
        this.descriptor = SerialDescriptorBuilderKt.PrimitiveDescriptor((String)"IdSerializer", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }

    @NotNull
    public T patch(@NotNull Decoder decoder, @NotNull T old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull(old, (String)"old");
        return (T)((Id)KSerializer.DefaultImpls.patch((KSerializer)this, (Decoder)decoder, old));
    }
}

