/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.Convention2;
import org.bson.codecs.pojo.IdGenerator;
import org.bson.codecs.pojo.IdPropertyModelHolder;
import org.bson.codecs.pojo.InstanceCreatorFactory;
import org.bson.codecs.pojo.PojoBuilderHelper2;
import org.bson.codecs.pojo.PropertyModel;
import org.bson.codecs.pojo.PropertyModelBuilder;
import org.bson.codecs.pojo.TypeParameterMap;

final class ClassModelBuilder2<T> {
    static final String ID_PROPERTY_NAME = "_id";
    private final List<PropertyModelBuilder<?>> propertyModelBuilders = new ArrayList();
    private IdGenerator<?> idGenerator;
    private InstanceCreatorFactory<T> instanceCreatorFactory;
    private Class<T> type;
    private Map<String, TypeParameterMap> propertyNameToTypeParameterMap = Collections.emptyMap();
    private List<Convention2> conventions = Collections.emptyList();
    private List<Annotation> annotations = Collections.emptyList();
    private boolean discriminatorEnabled;
    private String discriminator;
    private String discriminatorKey;
    private String idPropertyName;

    ClassModelBuilder2(Class<T> type) {
        PojoBuilderHelper2.configureClassModelBuilder(this, (Class)Assertions.notNull((String)"type", type));
    }

    public ClassModelBuilder2<T> idGenerator(IdGenerator<?> idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public IdGenerator<?> getIdGenerator() {
        return this.idGenerator;
    }

    public ClassModelBuilder2<T> instanceCreatorFactory(InstanceCreatorFactory<T> instanceCreatorFactory) {
        this.instanceCreatorFactory = (InstanceCreatorFactory)Assertions.notNull((String)"instanceCreatorFactory", instanceCreatorFactory);
        return this;
    }

    public InstanceCreatorFactory<T> getInstanceCreatorFactory() {
        return this.instanceCreatorFactory;
    }

    public ClassModelBuilder2<T> type(Class<T> type) {
        this.type = (Class)Assertions.notNull((String)"type", type);
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    public ClassModelBuilder2<T> conventions(List<Convention2> conventions) {
        this.conventions = (List)Assertions.notNull((String)"conventions", conventions);
        return this;
    }

    public List<Convention2> getConventions() {
        return this.conventions;
    }

    public ClassModelBuilder2<T> annotations(List<Annotation> annotations) {
        this.annotations = (List)Assertions.notNull((String)"annotations", annotations);
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public ClassModelBuilder2<T> discriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public ClassModelBuilder2<T> discriminatorKey(String discriminatorKey) {
        this.discriminatorKey = discriminatorKey;
        return this;
    }

    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    public ClassModelBuilder2<T> enableDiscriminator(boolean discriminatorEnabled) {
        this.discriminatorEnabled = discriminatorEnabled;
        return this;
    }

    public Boolean useDiscriminator() {
        return this.discriminatorEnabled;
    }

    public ClassModelBuilder2<T> idPropertyName(String idPropertyName) {
        this.idPropertyName = idPropertyName;
        return this;
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    public boolean removeProperty(String propertyName) {
        return this.propertyModelBuilders.remove(this.getProperty((String)Assertions.notNull((String)"propertyName", (Object)propertyName)));
    }

    public PropertyModelBuilder<?> getProperty(String propertyName) {
        Assertions.notNull((String)"propertyName", (Object)propertyName);
        for (PropertyModelBuilder<?> propertyModelBuilder : this.propertyModelBuilders) {
            if (!propertyModelBuilder.getName().equals(propertyName)) continue;
            return propertyModelBuilder;
        }
        return null;
    }

    public List<PropertyModelBuilder<?>> getPropertyModelBuilders() {
        return Collections.unmodifiableList(this.propertyModelBuilders);
    }

    public ClassModel<T> build() {
        ArrayList propertyModels = new ArrayList();
        PropertyModel idPropertyModel = null;
        PojoBuilderHelper2.stateNotNull("type", this.type);
        for (Convention2 convention2 : this.conventions) {
            convention2.apply(this);
        }
        PojoBuilderHelper2.stateNotNull("instanceCreatorFactory", this.instanceCreatorFactory);
        if (this.discriminatorEnabled) {
            PojoBuilderHelper2.stateNotNull("discriminatorKey", this.discriminatorKey);
            PojoBuilderHelper2.stateNotNull("discriminator", this.discriminator);
        }
        for (PropertyModelBuilder propertyModelBuilder : this.propertyModelBuilders) {
            boolean isIdProperty = propertyModelBuilder.getName().equals(this.idPropertyName);
            if (isIdProperty) {
                propertyModelBuilder.readName(ID_PROPERTY_NAME).writeName(ID_PROPERTY_NAME);
            }
            PropertyModel model = propertyModelBuilder.build();
            propertyModels.add(model);
            if (!isIdProperty) continue;
            idPropertyModel = model;
        }
        this.validatePropertyModels(this.type.getSimpleName(), propertyModels);
        return new ClassModel(this.type, this.propertyNameToTypeParameterMap, this.instanceCreatorFactory, Boolean.valueOf(this.discriminatorEnabled), this.discriminatorKey, this.discriminator, IdPropertyModelHolder.create(this.type, (PropertyModel)idPropertyModel, this.idGenerator), Collections.unmodifiableList(propertyModels));
    }

    public String toString() {
        return String.format("ClassModelBuilder{type=%s}", this.type);
    }

    Map<String, TypeParameterMap> getPropertyNameToTypeParameterMap() {
        return this.propertyNameToTypeParameterMap;
    }

    ClassModelBuilder2<T> propertyNameToTypeParameterMap(Map<String, TypeParameterMap> propertyNameToTypeParameterMap) {
        this.propertyNameToTypeParameterMap = Collections.unmodifiableMap(new HashMap<String, TypeParameterMap>(propertyNameToTypeParameterMap));
        return this;
    }

    ClassModelBuilder2<T> addProperty(PropertyModelBuilder<?> propertyModelBuilder) {
        this.propertyModelBuilders.add((PropertyModelBuilder)Assertions.notNull((String)"propertyModelBuilder", propertyModelBuilder));
        return this;
    }

    private void validatePropertyModels(String declaringClass, List<PropertyModel<?>> propertyModels) {
        HashMap<String, Integer> propertyNameMap = new HashMap<String, Integer>();
        HashMap<String, Integer> propertyReadNameMap = new HashMap<String, Integer>();
        HashMap<String, Integer> propertyWriteNameMap = new HashMap<String, Integer>();
        for (PropertyModel<?> propertyModel : propertyModels) {
            if (propertyModel.hasError()) {
                throw new CodecConfigurationException(propertyModel.getError());
            }
            this.checkForDuplicates("property", propertyModel.getName(), propertyNameMap, declaringClass);
            if (propertyModel.isReadable()) {
                this.checkForDuplicates("read property", propertyModel.getReadName(), propertyReadNameMap, declaringClass);
            }
            if (!propertyModel.isWritable()) continue;
            this.checkForDuplicates("write property", propertyModel.getWriteName(), propertyWriteNameMap, declaringClass);
        }
        if (this.idPropertyName != null && !propertyNameMap.containsKey(this.idPropertyName)) {
            throw new CodecConfigurationException(String.format("Invalid id property, property named '%s' can not be found.", this.idPropertyName));
        }
    }

    private void checkForDuplicates(String propertyType, String propertyName, Map<String, Integer> propertyNameMap, String declaringClass) {
        if (propertyNameMap.containsKey(propertyName)) {
            throw new CodecConfigurationException(String.format("Duplicate %s named '%s' found in %s.", propertyType, propertyName, declaringClass));
        }
        propertyNameMap.put(propertyName, 1);
    }
}

