/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.UuidRepresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.jackson.JacksonModuleServiceLoaderKt;
import org.litote.kmongo.jackson.BsonModule;
import org.litote.kmongo.jackson.CustomJacksonModule;
import org.litote.kmongo.jackson.ExtendedJsonModule;
import org.litote.kmongo.jackson.FilterIdModule;
import org.litote.kmongo.jackson.KMongoBsonFactory;
import org.litote.kmongo.jackson.StringDeserializationProblemHandler;
import org.litote.kmongo.util.KotlinModuleConfiguration;
import org.litote.kmongo.util.ObjectMappingConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0012\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0012\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"Lorg/litote/kmongo/jackson/ObjectMapperFactory;", "", "<init>", "()V", "createExtendedJsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createBsonObjectMapper", "uuidRepresentation", "Lorg/bson/UuidRepresentation;", "createBsonObjectMapperCopy", "configureBson", "mapper", "createFilterIdObjectMapper", "objectMapper", "SetMappingModule", "kmongo-jackson-mapping"})
public final class ObjectMapperFactory {
    @NotNull
    public static final ObjectMapperFactory INSTANCE = new ObjectMapperFactory();

    private ObjectMapperFactory() {
    }

    @NotNull
    public final ObjectMapper createExtendedJsonObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)ExtensionsKt.kotlinModule(KotlinModuleConfiguration.INSTANCE.getKotlinModuleInitializer())).registerModule((Module)new SetMappingModule()).registerModule((Module)new ExtendedJsonModule()).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true).setSerializationInclusion(ObjectMappingConfiguration.INSTANCE.getSerializeNull() ? JsonInclude.Include.ALWAYS : JsonInclude.Include.NON_NULL);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"setSerializationInclusion(...)");
        return JacksonModuleServiceLoaderKt.registerModulesFromServiceLoader((ObjectMapper)objectMapper);
    }

    @NotNull
    public final ObjectMapper createBsonObjectMapper(@Nullable UuidRepresentation uuidRepresentation) {
        return this.configureBson(new ObjectMapper((JsonFactory)new KMongoBsonFactory()), uuidRepresentation);
    }

    public static /* synthetic */ ObjectMapper createBsonObjectMapper$default(ObjectMapperFactory objectMapperFactory, UuidRepresentation uuidRepresentation, int n, Object object) {
        if ((n & 1) != 0) {
            uuidRepresentation = null;
        }
        return objectMapperFactory.createBsonObjectMapper(uuidRepresentation);
    }

    @NotNull
    public final ObjectMapper createBsonObjectMapperCopy(@Nullable UuidRepresentation uuidRepresentation) {
        return this.configureBson(new ObjectMapper(), uuidRepresentation);
    }

    public static /* synthetic */ ObjectMapper createBsonObjectMapperCopy$default(ObjectMapperFactory objectMapperFactory, UuidRepresentation uuidRepresentation, int n, Object object) {
        if ((n & 1) != 0) {
            uuidRepresentation = null;
        }
        return objectMapperFactory.createBsonObjectMapperCopy(uuidRepresentation);
    }

    private final ObjectMapper configureBson(ObjectMapper mapper, UuidRepresentation uuidRepresentation) {
        ObjectMapper objectMapper = mapper.registerModule((Module)new de.undercouch.bson4jackson.BsonModule()).registerModule((Module)ExtensionsKt.kotlinModule(KotlinModuleConfiguration.INSTANCE.getKotlinModuleInitializer())).registerModule((Module)CustomJacksonModule.INSTANCE).registerModule((Module)new SetMappingModule()).registerModule((Module)new BsonModule(uuidRepresentation)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true).setSerializationInclusion(ObjectMappingConfiguration.INSTANCE.getSerializeNull() ? JsonInclude.Include.ALWAYS : JsonInclude.Include.NON_NULL).addHandler((DeserializationProblemHandler)StringDeserializationProblemHandler.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"addHandler(...)");
        return JacksonModuleServiceLoaderKt.registerModulesFromServiceLoader((ObjectMapper)objectMapper);
    }

    @NotNull
    public final ObjectMapper createFilterIdObjectMapper(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        ObjectMapper objectMapper2 = objectMapper.copy().registerModule((Module)new FilterIdModule());
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"registerModule(...)");
        return objectMapper2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/litote/kmongo/jackson/ObjectMapperFactory$SetMappingModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "<init>", "()V", "kmongo-jackson-mapping"})
    private static final class SetMappingModule
    extends SimpleModule {
        public SetMappingModule() {
            this.addAbstractTypeMapping(Set.class, LinkedHashSet.class);
        }
    }
}

