/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import de.undercouch.bson4jackson.BsonFactory;
import de.undercouch.bson4jackson.BsonGenerator;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.io.ByteOrderUtil;
import de.undercouch.bson4jackson.types.Timestamp;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bson.BsonTimestamp;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.jackson.BsonModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0001H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/litote/kmongo/jackson/KMongoBsonFactory;", "Lde/undercouch/bson4jackson/BsonFactory;", "<init>", "()V", "createGenerator", "Lde/undercouch/bson4jackson/BsonGenerator;", "outputStream", "Ljava/io/OutputStream;", "enc", "Lcom/fasterxml/jackson/core/JsonEncoding;", "_createParser", "Lde/undercouch/bson4jackson/BsonParser;", "inputStream", "Ljava/io/InputStream;", "ctxt", "Lcom/fasterxml/jackson/core/io/IOContext;", "copy", "KMongoBsonGenerator", "KMongoBsonParser", "Companion", "kmongo-jackson-mapping"})
public final class KMongoBsonFactory
extends BsonFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int OBJECT_ID_LENGTH = 12;

    public KMongoBsonFactory() {
        this.enable(BsonParser.Feature.HONOR_DOCUMENT_LENGTH);
        this.enable(BsonGenerator.Feature.WRITE_BIGDECIMALS_AS_DECIMAL128);
    }

    @NotNull
    public BsonGenerator createGenerator(@NotNull OutputStream outputStream, @NotNull JsonEncoding enc) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)enc, (String)"enc");
        OutputStream out = outputStream;
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8 && this._outputDecorator != null) {
            OutputStream outputStream2 = this._outputDecorator.decorate(ctxt, out);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"decorate(...)");
            out = outputStream2;
        }
        KMongoBsonGenerator g = new KMongoBsonGenerator(this._generatorFeatures, this._bsonGeneratorFeatures, out);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g.setCodec(codec);
        }
        if (this._characterEscapes != null) {
            g.setCharacterEscapes(this._characterEscapes);
        }
        return g;
    }

    @NotNull
    protected BsonParser _createParser(@NotNull InputStream inputStream, @NotNull IOContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        KMongoBsonParser p = new KMongoBsonParser(ctxt, this._parserFeatures, this._bsonParserFeatures, inputStream);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            p.setCodec(codec);
        }
        return p;
    }

    @NotNull
    public BsonFactory copy() {
        return new KMongoBsonFactory();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/litote/kmongo/jackson/KMongoBsonFactory$Companion;", "", "<init>", "()V", "OBJECT_ID_LENGTH", "", "createFromLegacyFormat", "Lorg/bson/types/ObjectId;", "time", "machine", "inc", "legacyToBytes", "", "timestamp", "machineAndProcessIdentifier", "counter", "int3", "", "x", "int2", "int1", "int0", "kmongo-jackson-mapping"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectId createFromLegacyFormat(int time, int machine, int inc) {
            return new ObjectId(this.legacyToBytes(time, machine, inc));
        }

        private final byte[] legacyToBytes(int timestamp, int machineAndProcessIdentifier, int counter) {
            byte[] bytes = new byte[]{this.int3(timestamp), this.int2(timestamp), this.int1(timestamp), this.int0(timestamp), this.int3(machineAndProcessIdentifier), this.int2(machineAndProcessIdentifier), this.int1(machineAndProcessIdentifier), this.int0(machineAndProcessIdentifier), this.int3(counter), this.int2(counter), this.int1(counter), this.int0(counter)};
            return bytes;
        }

        private final byte int3(int x) {
            return (byte)(x >> 24);
        }

        private final byte int2(int x) {
            return (byte)(x >> 16);
        }

        private final byte int1(int x) {
            return (byte)(x >> 8);
        }

        private final byte int0(int x) {
            return (byte)x;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0016J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\f\u00a8\u0006\u0019"}, d2={"Lorg/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonGenerator;", "Lde/undercouch/bson4jackson/BsonGenerator;", "jsonFeatures", "", "bsonFeatures", "out", "Ljava/io/OutputStream;", "<init>", "(IILjava/io/OutputStream;)V", "canWriteObjectId", "", "writeObjectId", "", "objectId", "", "writeObjectRef", "id", "writeBinary", "binary", "Lorg/bson/types/Binary;", "writeBsonTimestamp", "timestamp", "Lorg/bson/BsonTimestamp;", "writeMinKey", "writeMaxKey", "kmongo-jackson-mapping"})
    @SourceDebugExtension(value={"SMAP\nKMongoBsonFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KMongoBsonFactory.kt\norg/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonGenerator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,219:1\n13479#2,2:220\n*S KotlinDebug\n*F\n+ 1 KMongoBsonFactory.kt\norg/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonGenerator\n*L\n60#1:220,2\n*E\n"})
    public static final class KMongoBsonGenerator
    extends BsonGenerator {
        public KMongoBsonGenerator(int jsonFeatures, int bsonFeatures, @NotNull OutputStream out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super(jsonFeatures, bsonFeatures, out);
        }

        public boolean canWriteObjectId() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void writeObjectId(@NotNull Object objectId) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            if (!(objectId instanceof ObjectId)) {
                if (!(objectId instanceof String)) throw new IllegalStateException((objectId + " has to be " + Reflection.getOrCreateKotlinClass(ObjectId.class)).toString());
                this.writeFieldName("_id");
                this.writeString((String)objectId);
                return;
            } else {
                this._writeArrayFieldNameIfNeeded();
                this._verifyValueWrite("write object id");
                this._buffer.putByte(this._typeMarker, (byte)7);
                byte[] byArray = ((ObjectId)objectId).toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                byte[] $this$forEach$iv = byArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    byte element$iv;
                    byte it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    this._buffer.putByte(it);
                }
                this.flushBuffer();
            }
        }

        public void writeObjectRef(@Nullable Object id) {
            if (id instanceof String) {
                this.writeString((String)id);
            } else {
                super.writeObjectRef(id);
            }
        }

        public final void writeBinary(@NotNull Binary binary) {
            Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write binary");
            byte[] bytes = binary.getData();
            this._buffer.putByte(this._typeMarker, (byte)5);
            this._buffer.putInt(bytes.length);
            this._buffer.putByte(binary.getType());
            byte[] byArray = binary.getData();
            this._buffer.putBytes(Arrays.copyOf(byArray, byArray.length));
            this.flushBuffer();
        }

        public final void writeBsonTimestamp(@NotNull BsonTimestamp timestamp) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write timestamp");
            this._buffer.putByte(this._typeMarker, (byte)17);
            this._buffer.putInt(timestamp.getInc());
            this._buffer.putInt(timestamp.getTime());
            this.flushBuffer();
        }

        public final void writeMinKey() {
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write min key");
            this._buffer.putByte(this._typeMarker, (byte)-1);
            this.flushBuffer();
        }

        public final void writeMaxKey() {
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write max key");
            this._buffer.putByte(this._typeMarker, (byte)127);
            this.flushBuffer();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonParser;", "Lde/undercouch/bson4jackson/BsonParser;", "ctxt", "Lcom/fasterxml/jackson/core/io/IOContext;", "jsonFeatures", "", "bsonFeatures", "inputStream", "Ljava/io/InputStream;", "<init>", "(Lcom/fasterxml/jackson/core/io/IOContext;IILjava/io/InputStream;)V", "getEmbeddedObject", "", "convertToBSONTimestamp", "ts", "Lde/undercouch/bson4jackson/types/Timestamp;", "convertToNativeObjectId", "Lorg/bson/types/ObjectId;", "id", "Lde/undercouch/bson4jackson/types/ObjectId;", "readObjectId", "kmongo-jackson-mapping"})
    private static final class KMongoBsonParser
    extends BsonParser {
        public KMongoBsonParser(@NotNull IOContext ctxt, int jsonFeatures, int bsonFeatures, @NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            super(ctxt, jsonFeatures, bsonFeatures, inputStream);
        }

        @NotNull
        public Object getEmbeddedObject() {
            Object embedded = super.getEmbeddedObject();
            if (embedded instanceof de.undercouch.bson4jackson.types.ObjectId) {
                return this.convertToNativeObjectId((de.undercouch.bson4jackson.types.ObjectId)embedded);
            }
            if (embedded instanceof Timestamp) {
                return this.convertToBSONTimestamp((Timestamp)embedded);
            }
            Intrinsics.checkNotNull((Object)embedded);
            return embedded;
        }

        private final Object convertToBSONTimestamp(Timestamp ts) {
            return new BsonTimestamp(ts.getTime(), ts.getInc());
        }

        private final ObjectId convertToNativeObjectId(de.undercouch.bson4jackson.types.ObjectId id) {
            return Companion.createFromLegacyFormat(id.getTime(), id.getMachine(), id.getInc());
        }

        @NotNull
        protected de.undercouch.bson4jackson.types.ObjectId readObjectId() {
            int time = ByteOrderUtil.flip((int)this._in.readInt());
            int machine = ByteOrderUtil.flip((int)this._in.readInt());
            int inc = ByteOrderUtil.flip((int)this._in.readInt());
            return new BsonModule.KMongoObjectId(time, machine, inc);
        }
    }
}

