/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/litote/kmongo/jackson/CustomJacksonModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "<init>", "()V", "kmongo-jackson-mapping"})
final class CustomJacksonModule
extends SimpleModule {
    @NotNull
    public static final CustomJacksonModule INSTANCE = new CustomJacksonModule();

    private CustomJacksonModule() {
    }

    static {
        INSTANCE.addSerializer(DBRef.class, (JsonSerializer)new JsonSerializer<DBRef>(){

            public void serialize(DBRef value, JsonGenerator gen, SerializerProvider serializers) {
                Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
                Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
                if (value == null) {
                    gen.writeNull();
                } else {
                    Object id;
                    gen.writeStartObject();
                    gen.writeStringField("$ref", value.getCollectionName());
                    gen.writeFieldName("$id");
                    Object object = id = value.getId();
                    if (object instanceof String) {
                        gen.writeString((String)id);
                    } else if (object instanceof Long) {
                        gen.writeNumber(((Number)id).longValue());
                    } else if (object instanceof Integer) {
                        gen.writeNumber(((Number)id).intValue());
                    } else if (object instanceof Float) {
                        gen.writeNumber(((Number)id).floatValue());
                    } else if (object instanceof Double) {
                        gen.writeNumber(((Number)id).doubleValue());
                    } else if (object instanceof BigInteger) {
                        gen.writeNumber((BigInteger)id);
                    } else if (object instanceof BigDecimal) {
                        gen.writeNumber((BigDecimal)id);
                    } else if (object instanceof ObjectId) {
                        gen.writeObjectId(id);
                    } else {
                        throw new IllegalStateException(("dbRef with id " + id + " of type " + id.getClass() + " is not supported").toString());
                    }
                    if (value.getDatabaseName() != null) {
                        gen.writeStringField("$db", value.getDatabaseName());
                    }
                    gen.writeEndObject();
                }
            }
        });
        INSTANCE.addDeserializer(DBRef.class, (JsonDeserializer)new JsonDeserializer<DBRef>(){

            public DBRef deserialize(JsonParser jp, DeserializationContext ctxt) {
                DBRef dBRef;
                Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
                Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
                if (jp.isExpectedStartObjectToken()) {
                    Object object;
                    jp.nextValue();
                    String ref = jp.getValueAsString();
                    jp.nextValue();
                    JsonToken jsonToken = jp.getCurrentToken();
                    switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                        case 1: {
                            object = jp.getEmbeddedObject();
                            break;
                        }
                        case 2: {
                            object = jp.getValueAsString();
                            break;
                        }
                        default: {
                            object = jp.getDecimalValue();
                        }
                    }
                    Object id = object;
                    String db = null;
                    while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                        if (Intrinsics.areEqual((Object)jp.getCurrentName(), (Object)"$db")) {
                            db = jp.getValueAsString();
                        }
                        jp.nextToken();
                    }
                    dBRef = new DBRef(db, ref, id);
                } else {
                    dBRef = null;
                }
                return dBRef;
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[JsonToken.values().length];
                    try {
                        nArray[JsonToken.VALUE_EMBEDDED_OBJECT.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[JsonToken.VALUE_STRING.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        try {
            INSTANCE.addSerializer(DBObject.class, (JsonSerializer)new JsonSerializer<DBObject>(){

                public void serialize(DBObject value, JsonGenerator gen, SerializerProvider serializers) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
                    Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
                    Map map = value.toMap();
                    serializers.findTypedValueSerializer(map.getClass(), true, null).serialize((Object)map, gen, serializers);
                }
            }).addDeserializer(DBObject.class, (JsonDeserializer)new JsonDeserializer<DBObject>(){

                public DBObject deserialize(JsonParser jp, DeserializationContext ctxt) {
                    Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
                    Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
                    Map map = (Map)jp.readValueAs(Map.class);
                    return (DBObject)new BasicDBObject(map);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

