/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.UuidRepresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.jackson.JacksonModuleServiceLoaderKt;
import org.litote.kmongo.jackson.BsonModule;
import org.litote.kmongo.jackson.CustomJacksonModule;
import org.litote.kmongo.jackson.ExtendedJsonModule;
import org.litote.kmongo.jackson.FilterIdModule;
import org.litote.kmongo.jackson.KMongoBsonFactory;
import org.litote.kmongo.jackson.StringDeserializationProblemHandler;
import org.litote.kmongo.util.ObjectMappingConfiguration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\b\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lorg/litote/kmongo/jackson/ObjectMapperFactory;", "", "()V", "configureBson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "mapper", "uuidRepresentation", "Lorg/bson/UuidRepresentation;", "createBsonObjectMapper", "createBsonObjectMapperCopy", "createExtendedJsonObjectMapper", "createFilterIdObjectMapper", "objectMapper", "SetMappingModule", "kmongo-jackson-mapping"})
public final class ObjectMapperFactory {
    @NotNull
    public static final ObjectMapperFactory INSTANCE = new ObjectMapperFactory();

    private ObjectMapperFactory() {
    }

    @NotNull
    public final ObjectMapper createExtendedJsonObjectMapper() {
        ObjectMapper objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper()).registerModule((Module)new SetMappingModule()).registerModule((Module)new ExtendedJsonModule()).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true).setSerializationInclusion(ObjectMappingConfiguration.INSTANCE.getSerializeNull() ? JsonInclude.Include.ALWAYS : JsonInclude.Include.NON_NULL);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"ObjectMapper()\n         \u2026ll) ALWAYS else NON_NULL)");
        return JacksonModuleServiceLoaderKt.registerModulesFromServiceLoader((ObjectMapper)objectMapper);
    }

    @NotNull
    public final ObjectMapper createBsonObjectMapper(@Nullable UuidRepresentation uuidRepresentation) {
        return this.configureBson(new ObjectMapper((JsonFactory)new KMongoBsonFactory()), uuidRepresentation);
    }

    public static /* synthetic */ ObjectMapper createBsonObjectMapper$default(ObjectMapperFactory objectMapperFactory, UuidRepresentation uuidRepresentation, int n, Object object) {
        if ((n & 1) != 0) {
            uuidRepresentation = null;
        }
        return objectMapperFactory.createBsonObjectMapper(uuidRepresentation);
    }

    @NotNull
    public final ObjectMapper createBsonObjectMapperCopy(@Nullable UuidRepresentation uuidRepresentation) {
        return this.configureBson(new ObjectMapper(), uuidRepresentation);
    }

    public static /* synthetic */ ObjectMapper createBsonObjectMapperCopy$default(ObjectMapperFactory objectMapperFactory, UuidRepresentation uuidRepresentation, int n, Object object) {
        if ((n & 1) != 0) {
            uuidRepresentation = null;
        }
        return objectMapperFactory.createBsonObjectMapperCopy(uuidRepresentation);
    }

    private final ObjectMapper configureBson(ObjectMapper mapper, UuidRepresentation uuidRepresentation) {
        ObjectMapper objectMapper = mapper.registerModule((Module)new de.undercouch.bson4jackson.BsonModule());
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"mapper.registerModule(de\u2026son4jackson.BsonModule())");
        ObjectMapper objectMapper2 = ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper).registerModule((Module)CustomJacksonModule.INSTANCE).registerModule((Module)new SetMappingModule()).registerModule((Module)new BsonModule(uuidRepresentation)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true).setSerializationInclusion(ObjectMappingConfiguration.INSTANCE.getSerializeNull() ? JsonInclude.Include.ALWAYS : JsonInclude.Include.NON_NULL).addHandler((DeserializationProblemHandler)StringDeserializationProblemHandler.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"mapper.registerModule(de\u2026ializationProblemHandler)");
        return JacksonModuleServiceLoaderKt.registerModulesFromServiceLoader((ObjectMapper)objectMapper2);
    }

    @NotNull
    public final ObjectMapper createFilterIdObjectMapper(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        ObjectMapper objectMapper2 = objectMapper.copy().registerModule((Module)new FilterIdModule());
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"objectMapper.copy().regi\u2026rModule(FilterIdModule())");
        return objectMapper2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/litote/kmongo/jackson/ObjectMapperFactory$SetMappingModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "()V", "kmongo-jackson-mapping"})
    private static final class SetMappingModule
    extends SimpleModule {
        public SetMappingModule() {
            this.addAbstractTypeMapping(Set.class, LinkedHashSet.class);
        }
    }
}

