/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.jackson.CustomJacksonModule$WhenMappings;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/litote/kmongo/jackson/CustomJacksonModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "()V", "kmongo-jackson-mapping"})
final class CustomJacksonModule
extends SimpleModule {
    public static final CustomJacksonModule INSTANCE;

    private CustomJacksonModule() {
    }

    static {
        CustomJacksonModule customJacksonModule;
        INSTANCE = customJacksonModule = new CustomJacksonModule();
        customJacksonModule.addSerializer(DBRef.class, (JsonSerializer)new JsonSerializer<DBRef>(){

            public void serialize(@Nullable DBRef value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
                Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
                Intrinsics.checkParameterIsNotNull((Object)serializers, (String)"serializers");
                if (value == null) {
                    gen.writeNull();
                } else {
                    Object id;
                    gen.writeStartObject();
                    gen.writeStringField("$ref", value.getCollectionName());
                    gen.writeFieldName("$id");
                    Object object = id = value.getId();
                    if (object instanceof String) {
                        gen.writeString((String)id);
                    } else if (object instanceof Long) {
                        gen.writeNumber(((Number)id).longValue());
                    } else if (object instanceof Integer) {
                        gen.writeNumber(((Number)id).intValue());
                    } else if (object instanceof Float) {
                        gen.writeNumber(((Number)id).floatValue());
                    } else if (object instanceof Double) {
                        gen.writeNumber(((Number)id).doubleValue());
                    } else if (object instanceof BigInteger) {
                        gen.writeNumber((BigInteger)id);
                    } else if (object instanceof BigDecimal) {
                        gen.writeNumber((BigDecimal)id);
                    } else if (object instanceof ObjectId) {
                        gen.writeObjectId(id);
                    } else {
                        String string = "dbRef with id " + id + " of type " + id.getClass() + " is not supported";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    if (value.getDatabaseName() != null) {
                        gen.writeStringField("$db", value.getDatabaseName());
                    }
                    gen.writeEndObject();
                }
            }
        });
        customJacksonModule.addDeserializer(DBRef.class, (JsonDeserializer)new JsonDeserializer<DBRef>(){

            /*
             * Unable to fully structure code
             */
            @Nullable
            public DBRef deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
                block7: {
                    block6: {
                        Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
                        Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
                        if (!jp.isExpectedStartObjectToken()) break block6;
                        jp.nextValue();
                        ref = jp.getValueAsString();
                        jp.nextValue();
                        v0 = jp.getCurrentToken();
                        if (v0 == null) ** GOTO lbl-1000
                        switch (CustomJacksonModule$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                            case 1: {
                                v1 = jp.getEmbeddedObject();
                                break;
                            }
                            case 2: {
                                v1 = jp.getValueAsString();
                                break;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                v1 = jp.getDecimalValue();
                            }
                        }
                        id = v1;
                        db = null;
                        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                            if (Intrinsics.areEqual((Object)jp.getCurrentName(), (Object)"$db")) {
                                db = jp.getValueAsString();
                            }
                            jp.nextToken();
                        }
                        v2 = new DBRef(db, ref, (Object)id);
                        break block7;
                    }
                    v2 = null;
                }
                return v2;
            }
        });
        try {
            customJacksonModule.addSerializer(DBObject.class, (JsonSerializer)new JsonSerializer<DBObject>(){

                public void serialize(@NotNull DBObject value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
                    Intrinsics.checkParameterIsNotNull((Object)serializers, (String)"serializers");
                    Map map = value.toMap();
                    serializers.findTypedValueSerializer(map.getClass(), true, null).serialize((Object)map, gen, serializers);
                }
            }).addDeserializer(DBObject.class, (JsonDeserializer)new JsonDeserializer<DBObject>(){

                @Nullable
                public DBObject deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
                    Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
                    Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
                    Map map = (Map)jp.readValueAs(Map.class);
                    return (DBObject)new BasicDBObject(map);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

