/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.common.model;

import chat.rocket.common.model.Email;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import se.ansman.kotshi.KotshiUtils;
import se.ansman.kotshi.NamedJsonAdapter;

public final class KotshiEmailJsonAdapter
extends NamedJsonAdapter<Email> {
    private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])new String[]{"address", "verified"});

    public KotshiEmailJsonAdapter() {
        super("KotshiJsonAdapter(Email)");
    }

    public void toJson(JsonWriter writer, Email value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("address");
        writer.value(value.getAddress());
        writer.name("verified");
        writer.value(value.getVerified());
        writer.endObject();
    }

    public Email fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Email)reader.nextNull();
        }
        reader.beginObject();
        String address = null;
        boolean verified = false;
        block5: while (reader.hasNext()) {
            switch (reader.selectName(OPTIONS)) {
                case 0: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block5;
                    }
                    address = reader.nextString();
                    continue block5;
                }
                case 1: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block5;
                    }
                    verified = reader.nextBoolean();
                    continue block5;
                }
                case -1: {
                    reader.nextName();
                    reader.skipValue();
                    continue block5;
                }
            }
        }
        reader.endObject();
        StringBuilder stringBuilder = null;
        if (address == null) {
            stringBuilder = KotshiUtils.appendNullableError(stringBuilder, (String)"address");
        }
        if (stringBuilder != null) {
            throw new NullPointerException(stringBuilder.toString());
        }
        return new Email(address, verified);
    }
}

