/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.util;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.litepal.exceptions.DatabaseGenerateException;
import org.litepal.tablemanager.model.TableModel;
import org.litepal.util.BaseUtility;

public class DBUtility {
    private DBUtility() {
    }

    public static String getTableNameByClassName(String className) {
        if (!TextUtils.isEmpty((CharSequence)className)) {
            if ('.' == className.charAt(className.length() - 1)) {
                return null;
            }
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static List<String> getTableNameListByClassNameList(List<String> classNames) {
        ArrayList<String> tableNames = new ArrayList<String>();
        if (classNames != null && !classNames.isEmpty()) {
            for (String className : classNames) {
                tableNames.add(DBUtility.getTableNameByClassName(className));
            }
        }
        return tableNames;
    }

    public static String getTableNameByForeignColumn(String foreignColumnName) {
        if (!TextUtils.isEmpty((CharSequence)foreignColumnName)) {
            if (foreignColumnName.toLowerCase().endsWith("_id")) {
                return foreignColumnName.substring(0, foreignColumnName.length() - "_id".length());
            }
            return null;
        }
        return null;
    }

    public static String getIntermediateTableName(String tableName, String associatedTableName) {
        if (!TextUtils.isEmpty((CharSequence)tableName) && !TextUtils.isEmpty((CharSequence)associatedTableName)) {
            String intermediateTableName = null;
            intermediateTableName = tableName.toLowerCase().compareTo(associatedTableName.toLowerCase()) <= 0 ? tableName + "_" + associatedTableName : associatedTableName + "_" + tableName;
            return intermediateTableName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIntermediateTable(String tableName, SQLiteDatabase db) {
        block10: {
            if (!TextUtils.isEmpty((CharSequence)tableName) && tableName.matches("[0-9a-zA-Z]+_[0-9a-zA-Z]+")) {
                try (Cursor cursor = null;){
                    cursor = db.query("table_schema", null, null, null, null, null, null);
                    if (!cursor.moveToFirst()) break block10;
                    do {
                        String tableNameDB;
                        if (!tableName.equalsIgnoreCase(tableNameDB = cursor.getString(cursor.getColumnIndexOrThrow("name")))) continue;
                        int tableType = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                        if (tableType == 1) {
                            boolean bl = true;
                            return bl;
                        }
                        break;
                    } while (cursor.moveToNext());
                }
            }
        }
        return false;
    }

    public static boolean isTableExists(String tableName, SQLiteDatabase db) {
        boolean exist;
        try {
            exist = BaseUtility.containsIgnoreCases(DBUtility.findAllTableNames(db), tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            exist = false;
        }
        return exist;
    }

    public static boolean isColumnExists(String columnName, String tableName, SQLiteDatabase db) {
        if (TextUtils.isEmpty((CharSequence)columnName) || TextUtils.isEmpty((CharSequence)tableName)) {
            return false;
        }
        boolean exist = false;
        try {
            exist = BaseUtility.containsIgnoreCases(DBUtility.findPragmaTableInfo(tableName, db).getColumnNames(), columnName);
        }
        catch (Exception e) {
            e.printStackTrace();
            exist = false;
        }
        return exist;
    }

    public static List<String> findAllTableNames(SQLiteDatabase db) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (Cursor cursor = null;){
            cursor = db.rawQuery("select * from sqlite_master where type = ?", new String[]{"table"});
            if (cursor.moveToFirst()) {
                do {
                    String tableName;
                    if (tableNames.contains(tableName = cursor.getString(cursor.getColumnIndexOrThrow("tbl_name")))) continue;
                    tableNames.add(tableName);
                } while (cursor.moveToNext());
            }
        }
        return tableNames;
    }

    public static TableModel findPragmaTableInfo(String tableName, SQLiteDatabase db) {
        if (DBUtility.isTableExists(tableName, db)) {
            TableModel tableModelDB = new TableModel();
            tableModelDB.setTableName(tableName);
            String checkingColumnSQL = "pragma table_info(" + tableName + ")";
            try (Cursor cursor = null;){
                cursor = db.rawQuery(checkingColumnSQL, null);
                if (cursor.moveToFirst()) {
                    do {
                        String name = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                        String type = cursor.getString(cursor.getColumnIndexOrThrow("type"));
                        tableModelDB.addColumn(name, type);
                    } while (cursor.moveToNext());
                }
            }
            return tableModelDB;
        }
        throw new DatabaseGenerateException("Table doesn't exist when executing " + tableName);
    }
}

