/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.util;

import android.text.TextUtils;
import java.util.Collection;
import java.util.Locale;
import org.litepal.exceptions.DataSupportException;
import org.litepal.parser.LitePalAttr;

public class BaseUtility {
    private BaseUtility() {
    }

    public static String changeCase(String string) {
        if (string != null) {
            LitePalAttr litePalAttr = LitePalAttr.getInstance();
            String cases = litePalAttr.getCases();
            if ("keep".equals(cases)) {
                return string;
            }
            if ("upper".equals(cases)) {
                return string.toUpperCase(Locale.US);
            }
            return string.toLowerCase(Locale.US);
        }
        return null;
    }

    public static boolean containsIgnoreCases(Collection<String> collection, String string) {
        if (collection == null) {
            return false;
        }
        if (string == null) {
            return collection.contains(null);
        }
        boolean contains = false;
        for (String element : collection) {
            if (!string.equalsIgnoreCase(element)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static String capitalize(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1);
        }
        return string == null ? null : "";
    }

    public static int count(String string, String mark) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)mark)) {
            int count = 0;
            int index = string.indexOf(mark);
            while (index != -1) {
                ++count;
                string = string.substring(index + mark.length());
                index = string.indexOf(mark);
            }
            return count;
        }
        return 0;
    }

    public static void checkConditionsCorrect(String ... conditions) {
        String whereClause;
        int placeHolderSize;
        int conditionsSize;
        if (conditions != null && (conditionsSize = conditions.length) > 0 && conditionsSize != (placeHolderSize = BaseUtility.count(whereClause = conditions[0], "?")) + 1) {
            throw new DataSupportException("The parameters in conditions are incorrect.");
        }
    }

    public static boolean isFieldTypeSupported(String fieldType) {
        if ("boolean".equals(fieldType) || "java.lang.Boolean".equals(fieldType)) {
            return true;
        }
        if ("float".equals(fieldType) || "java.lang.Float".equals(fieldType)) {
            return true;
        }
        if ("double".equals(fieldType) || "java.lang.Double".equals(fieldType)) {
            return true;
        }
        if ("int".equals(fieldType) || "java.lang.Integer".equals(fieldType)) {
            return true;
        }
        if ("long".equals(fieldType) || "java.lang.Long".equals(fieldType)) {
            return true;
        }
        if ("short".equals(fieldType) || "java.lang.Short".equals(fieldType)) {
            return true;
        }
        if ("char".equals(fieldType) || "java.lang.Character".equals(fieldType)) {
            return true;
        }
        return "java.lang.String".equals(fieldType) || "java.util.Date".equals(fieldType);
    }
}

