/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.tablemanager;

import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.litepal.tablemanager.AssociationUpdater;
import org.litepal.tablemanager.model.TableModel;
import org.litepal.util.BaseUtility;
import org.litepal.util.LogUtil;

public class Upgrader
extends AssociationUpdater {
    protected TableModel mTableModel;

    @Override
    protected void createOrUpgradeTable(SQLiteDatabase db, boolean force) {
        this.mDb = db;
        Iterator<TableModel> i$ = this.getAllTableModels().iterator();
        while (i$.hasNext()) {
            TableModel tableModel;
            this.mTableModel = tableModel = i$.next();
            this.upgradeTable();
        }
    }

    private void upgradeTable() {
        this.removeColumns(this.findColumnsToRemove(), this.mTableModel.getTableName());
        this.addColumn(this.findColumnsToAdd());
        this.changeColumnsType(this.findColumnTypesToChange());
    }

    private Map<String, String> findColumnsToAdd() {
        HashMap<String, String> newColumnsMap = new HashMap<String, String>();
        for (String columnName : this.mTableModel.getColumnNames()) {
            boolean isNewColumn = true;
            for (String dbColumnName : this.getTableModelFromDB(this.mTableModel.getTableName()).getColumnNames()) {
                if (!columnName.equalsIgnoreCase(dbColumnName)) continue;
                isNewColumn = false;
                break;
            }
            if (!isNewColumn || this.isIdColumn(columnName)) continue;
            newColumnsMap.put(columnName, this.mTableModel.getColumns().get(columnName));
        }
        return newColumnsMap;
    }

    private List<String> findColumnsToRemove() {
        TableModel tableModelDB = this.getTableModelFromDB(this.mTableModel.getTableName());
        ArrayList<String> removeColumns = new ArrayList<String>();
        Map<String, String> dbColumnsMap = tableModelDB.getColumns();
        Set<String> dbColumnNames = dbColumnsMap.keySet();
        for (String dbColumnName : dbColumnNames) {
            if (!this.isNeedToRemove(dbColumnName)) continue;
            removeColumns.add(dbColumnName);
        }
        for (String removeColumn : removeColumns) {
            LogUtil.d("AssociationUpdater", "remove column is >> " + removeColumn);
        }
        return removeColumns;
    }

    private Map<String, String> findColumnTypesToChange() {
        HashMap<String, String> changeTypeColumns = new HashMap<String, String>();
        TableModel tableModelDB = this.getTableModelFromDB(this.mTableModel.getTableName());
        for (String columnNameDB : tableModelDB.getColumnNames()) {
            for (String columnName : this.mTableModel.getColumnNames()) {
                String columnType;
                String columnTypeDB;
                if (!columnNameDB.equalsIgnoreCase(columnName) || (columnTypeDB = tableModelDB.getColumns().get(columnNameDB)).equalsIgnoreCase(columnType = this.mTableModel.getColumns().get(columnName))) continue;
                changeTypeColumns.put(columnName, columnType);
            }
        }
        return changeTypeColumns;
    }

    private boolean isNeedToRemove(String columnName) {
        return this.isRemovedFromClass(columnName) && !this.isIdColumn(columnName) && !this.isForeignKeyColumn(this.mTableModel, columnName);
    }

    private boolean isRemovedFromClass(String columnName) {
        return !BaseUtility.containsIgnoreCases(this.mTableModel.getColumnNames(), columnName);
    }

    private String generateAddColumnSQL(String columnName, String columnType) {
        return this.generateAddColumnSQL(this.mTableModel.getTableName(), columnName, columnType);
    }

    private String[] getAddColumnSQLs(Map<String, String> newColumnsMap) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (String columnName : newColumnsMap.keySet()) {
            sqls.add(this.generateAddColumnSQL(columnName, newColumnsMap.get(columnName)));
        }
        return sqls.toArray(new String[0]);
    }

    private void addColumn(Map<String, String> columnsMap) {
        this.execute(this.getAddColumnSQLs(columnsMap), this.mDb);
    }

    private void changeColumnsType(Map<String, String> changeTypeColumns) {
        this.removeColumns(changeTypeColumns.keySet(), this.mTableModel.getTableName());
        this.addColumn(changeTypeColumns);
    }
}

