/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.tablemanager;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.Collection;
import org.litepal.LitePalBase;
import org.litepal.exceptions.DatabaseGenerateException;
import org.litepal.parser.LitePalAttr;
import org.litepal.tablemanager.Creator;
import org.litepal.tablemanager.Dropper;
import org.litepal.tablemanager.Upgrader;
import org.litepal.tablemanager.model.AssociationsModel;
import org.litepal.tablemanager.model.TableModel;
import org.litepal.util.BaseUtility;

public abstract class Generator
extends LitePalBase {
    public static final String TAG = "Generator";
    private Collection<TableModel> mTableModels;
    private Collection<AssociationsModel> mAllRelationModels;

    protected Collection<TableModel> getAllTableModels() {
        if (this.mTableModels == null) {
            this.mTableModels = new ArrayList<TableModel>();
        }
        if (!this.canUseCache()) {
            this.mTableModels.clear();
            for (String className : LitePalAttr.getInstance().getClassNames()) {
                this.mTableModels.add(this.getTableModel(className));
            }
        }
        return this.mTableModels;
    }

    protected Collection<AssociationsModel> getAllAssociations() {
        if (this.mAllRelationModels == null || this.mAllRelationModels.isEmpty()) {
            this.mAllRelationModels = this.getAssociations(LitePalAttr.getInstance().getClassNames());
        }
        return this.mAllRelationModels;
    }

    protected void execute(String[] sqls, SQLiteDatabase db) {
        String throwSQL = "";
        try {
            if (sqls != null) {
                String[] arr$ = sqls;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String sql;
                    throwSQL = sql = arr$[i$];
                    db.execSQL(BaseUtility.changeCase(sql));
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseGenerateException("An exception that indicates there was an error with SQL parsing or execution. " + throwSQL);
        }
    }

    private static void addAssociation(SQLiteDatabase db, boolean force) {
        Creator associationsCreator = new Creator();
        associationsCreator.addOrUpdateAssociation(db, force);
    }

    private static void updateAssociations(SQLiteDatabase db) {
        Upgrader associationUpgrader = new Upgrader();
        associationUpgrader.addOrUpdateAssociation(db, false);
    }

    private static void upgradeTables(SQLiteDatabase db) {
        Upgrader upgrader = new Upgrader();
        upgrader.createOrUpgradeTable(db, false);
    }

    private static void create(SQLiteDatabase db, boolean force) {
        Creator creator = new Creator();
        creator.createOrUpgradeTable(db, force);
    }

    private static void drop(SQLiteDatabase db) {
        Dropper dropper = new Dropper();
        dropper.createOrUpgradeTable(db, false);
    }

    private boolean canUseCache() {
        if (this.mTableModels == null) {
            return false;
        }
        return this.mTableModels.size() == LitePalAttr.getInstance().getClassNames().size();
    }

    static void create(SQLiteDatabase db) {
        Generator.create(db, true);
        Generator.addAssociation(db, true);
    }

    static void upgrade(SQLiteDatabase db) {
        Generator.drop(db);
        Generator.create(db, false);
        Generator.updateAssociations(db);
        Generator.upgradeTables(db);
        Generator.addAssociation(db, false);
    }

    protected abstract void createOrUpgradeTable(SQLiteDatabase var1, boolean var2);

    protected abstract void addOrUpdateAssociation(SQLiteDatabase var1, boolean var2);
}

