/*
 * Decompiled with CFR 0.152.
 */
package org.litepal.tablemanager;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.litepal.tablemanager.AssociationUpdater;
import org.litepal.tablemanager.model.TableModel;
import org.litepal.util.BaseUtility;
import org.litepal.util.LogUtil;

public class Dropper
extends AssociationUpdater {
    private Collection<TableModel> mTableModels;

    @Override
    protected void createOrUpgradeTable(SQLiteDatabase db, boolean force) {
        this.mTableModels = this.getAllTableModels();
        this.mDb = db;
        this.dropTables();
    }

    private void dropTables() {
        List<String> tableNamesToDrop = this.findTablesToDrop();
        this.dropTables(tableNamesToDrop, this.mDb);
        this.clearCopyInTableSchema(tableNamesToDrop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findTablesToDrop() {
        ArrayList<String> dropTableNames = new ArrayList<String>();
        try (Cursor cursor = null;){
            cursor = this.mDb.query("table_schema", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    int tableType;
                    String tableName;
                    if (!this.shouldDropThisTable(tableName = cursor.getString(cursor.getColumnIndexOrThrow("name")), tableType = cursor.getInt(cursor.getColumnIndexOrThrow("type")))) continue;
                    LogUtil.d("AssociationUpdater", "need to drop " + tableName);
                    dropTableNames.add(tableName);
                } while (cursor.moveToNext());
            }
        }
        return dropTableNames;
    }

    private List<String> pickTableNamesFromTableModels() {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (TableModel tableModel : this.mTableModels) {
            tableNames.add(tableModel.getTableName());
        }
        return tableNames;
    }

    private boolean shouldDropThisTable(String tableName, int tableType) {
        return !BaseUtility.containsIgnoreCases(this.pickTableNamesFromTableModels(), tableName) && tableType == 0;
    }
}

